/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.impl;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneRulesException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocket;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.BaseContext;
import org.mariadb.jdbc.client.context.RedoContext;
import org.mariadb.jdbc.client.impl.ConnectionHelper;
import org.mariadb.jdbc.client.impl.PrepareCache;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.result.StreamingResult;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.socket.impl.CompressInputStream;
import org.mariadb.jdbc.client.socket.impl.CompressOutputStream;
import org.mariadb.jdbc.client.socket.impl.PacketReader;
import org.mariadb.jdbc.client.socket.impl.PacketWriter;
import org.mariadb.jdbc.client.socket.impl.ReadAheadBufferedStream;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.MaxAllowedPacketException;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.ClosePreparePacket;
import org.mariadb.jdbc.message.client.HandshakeResponse;
import org.mariadb.jdbc.message.client.QueryPacket;
import org.mariadb.jdbc.message.client.QuitPacket;
import org.mariadb.jdbc.message.server.ErrorPacket;
import org.mariadb.jdbc.message.server.InitialHandshakePacket;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.plugin.Credential;
import org.mariadb.jdbc.plugin.CredentialPlugin;
import org.mariadb.jdbc.util.Security;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class StandardClient
implements Client,
AutoCloseable {
    private static final Logger logger = Loggers.getLogger(StandardClient.class);
    private final Socket socket;
    private final MutableInt sequence = new MutableInt();
    private final MutableInt compressionSequence = new MutableInt();
    private final ReentrantLock lock;
    private final Configuration conf;
    private final HostAddress hostAddress;
    private boolean closed = false;
    private Reader reader;
    private Statement streamStmt = null;
    private ClientMessage streamMsg = null;
    private int socketTimeout;
    private final boolean disablePipeline;
    protected Context context;
    protected final ExceptionFactory exceptionFactory;
    protected Writer writer;

    public StandardClient(Configuration conf, HostAddress hostAddress, ReentrantLock lock, boolean skipPostCommands) throws SQLException {
        this.conf = conf;
        this.lock = lock;
        this.hostAddress = hostAddress;
        this.exceptionFactory = new ExceptionFactory(conf, hostAddress);
        this.disablePipeline = Boolean.parseBoolean(conf.nonMappedOptions().getProperty("disablePipeline", "false"));
        String host = hostAddress != null ? hostAddress.host : null;
        this.socketTimeout = conf.socketTimeout();
        this.socket = ConnectionHelper.connectSocket(conf, hostAddress);
        try {
            ReadableByteBuf buf;
            OutputStream out = this.socket.getOutputStream();
            FilterInputStream in = conf.useReadAheadInput() ? new ReadAheadBufferedStream(this.socket.getInputStream()) : new BufferedInputStream(this.socket.getInputStream(), 16384);
            this.assignStream(out, in, conf, null);
            if (conf.socketTimeout() > 0) {
                this.setSocketTimeout(conf.socketTimeout());
            }
            if ((buf = this.reader.readPacket(true)).getByte() == -1) {
                ErrorPacket errorPacket = new ErrorPacket(buf, null);
                throw this.exceptionFactory.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            InitialHandshakePacket handshake = InitialHandshakePacket.decode(buf);
            this.exceptionFactory.setThreadId(handshake.getThreadId());
            long clientCapabilities = ConnectionHelper.initializeClientCapabilities(conf, handshake.getCapabilities());
            this.context = conf.transactionReplay() ? new RedoContext(handshake, clientCapabilities, conf, this.exceptionFactory, new PrepareCache(conf.prepStmtCacheSize(), this)) : new BaseContext(handshake, clientCapabilities, conf, this.exceptionFactory, new PrepareCache(conf.prepStmtCacheSize(), this));
            this.reader.setServerThreadId(handshake.getThreadId(), hostAddress);
            this.writer.setServerThreadId(handshake.getThreadId(), hostAddress);
            byte exchangeCharset = ConnectionHelper.decideLanguage(handshake);
            SSLSocket sslSocket = ConnectionHelper.sslWrapper(hostAddress, this.socket, clientCapabilities, exchangeCharset, this.context, this.writer);
            if (sslSocket != null) {
                out = sslSocket.getOutputStream();
                in = conf.useReadAheadInput() ? new ReadAheadBufferedStream(sslSocket.getInputStream()) : new BufferedInputStream(sslSocket.getInputStream(), 16384);
                this.assignStream(out, in, conf, handshake.getThreadId());
            }
            String authenticationPluginType = handshake.getAuthenticationPluginType();
            CredentialPlugin credentialPlugin = conf.credentialPlugin();
            if (credentialPlugin != null && credentialPlugin.defaultAuthenticationPluginType() != null) {
                authenticationPluginType = credentialPlugin.defaultAuthenticationPluginType();
            }
            Credential credential = ConnectionHelper.loadCredential(credentialPlugin, conf, hostAddress);
            new HandshakeResponse(credential, authenticationPluginType, this.context.getSeed(), conf, host, clientCapabilities, exchangeCharset).encode(this.writer, this.context);
            this.writer.flush();
            ConnectionHelper.authenticationHandler(credential, this.writer, this.reader, this.context);
            if ((clientCapabilities & 0x20L) != 0L) {
                this.assignStream(new CompressOutputStream(out, this.compressionSequence), new CompressInputStream(in, this.compressionSequence), conf, handshake.getThreadId());
            }
            if (!skipPostCommands) {
                this.postConnectionQueries();
            }
        }
        catch (IOException ioException) {
            this.destroySocket();
            String errorMsg = String.format("Could not connect to %s:%s : %s", host, this.socket.getPort(), ioException.getMessage());
            if (host == null) {
                errorMsg = String.format("Could not connect to socket : %s", ioException.getMessage());
            }
            throw this.exceptionFactory.create(errorMsg, "08000", ioException);
        }
        catch (SQLException sqlException) {
            this.destroySocket();
            throw sqlException;
        }
    }

    private void assignStream(OutputStream out, InputStream in, Configuration conf, Long threadId) {
        this.writer = new PacketWriter(out, conf.maxQuerySizeToLog(), conf.maxAllowedPacket(), this.sequence, this.compressionSequence);
        this.writer.setServerThreadId(threadId, this.hostAddress);
        this.reader = new PacketReader(in, conf, this.sequence);
        this.reader.setServerThreadId(threadId, this.hostAddress);
    }

    protected void destroySocket() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String handleTimezone() throws SQLException {
        if (!"disable".equalsIgnoreCase(this.conf.timezone())) {
            String timeZone;
            block6: {
                timeZone = null;
                try {
                    Result res = (Result)this.execute(new QueryPacket("SELECT @@time_zone, @@system_time_zone"), true).get(0);
                    res.next();
                    timeZone = res.getString(1);
                    if ("SYSTEM".equals(timeZone)) {
                        timeZone = res.getString(2);
                    }
                }
                catch (SQLException sqle) {
                    Result res = (Result)this.execute(new QueryPacket("SHOW VARIABLES WHERE Variable_name in ('system_time_zone','time_zone')"), true).get(0);
                    String systemTimeZone = null;
                    while (res.next()) {
                        if ("system_time_zone".equals(res.getString(1))) {
                            systemTimeZone = res.getString(2);
                            continue;
                        }
                        timeZone = res.getString(2);
                    }
                    if (!"SYSTEM".equals(timeZone)) break block6;
                    timeZone = systemTimeZone;
                }
            }
            return timeZone;
        }
        return null;
    }

    private void postConnectionQueries() throws SQLException {
        String serverTz;
        String sessionVariableQuery;
        List galeraAllowedStates;
        ArrayList<String> commands = new ArrayList<String>();
        List<Object> list = galeraAllowedStates = this.conf.galeraAllowedState() == null ? Collections.emptyList() : Arrays.asList(this.conf.galeraAllowedState().split(","));
        if (this.hostAddress != null && Boolean.TRUE.equals(this.hostAddress.primary) && !galeraAllowedStates.isEmpty()) {
            commands.add("show status like 'wsrep_local_state'");
        }
        if ((sessionVariableQuery = this.createSessionVariableQuery(serverTz = this.conf.timezone() != null ? this.handleTimezone() : null)) != null) {
            commands.add(sessionVariableQuery);
        }
        if (this.hostAddress != null && !this.hostAddress.primary.booleanValue() && this.context.getVersion().versionGreaterOrEqual(5, 6, 5)) {
            commands.add("SET SESSION TRANSACTION READ ONLY");
        }
        if (this.conf.database() != null && this.conf.createDatabaseIfNotExist()) {
            String escapedDb = this.conf.database().replace("`", "``");
            commands.add(String.format("CREATE DATABASE IF NOT EXISTS `%s`", escapedDb));
            commands.add(String.format("USE `%s`", escapedDb));
        }
        if (!commands.isEmpty()) {
            try {
                ClientMessage[] msgs = new ClientMessage[commands.size()];
                for (int i = 0; i < commands.size(); ++i) {
                    msgs[i] = new QueryPacket((String)commands.get(i));
                }
                List<Completion> res = this.executePipeline(msgs, null, 0, 0L, 1007, 1003, false, true);
                if (this.hostAddress != null && Boolean.TRUE.equals(this.hostAddress.primary) && !galeraAllowedStates.isEmpty()) {
                    ResultSet rs = (ResultSet)((Object)res.get(2));
                    rs.next();
                    if (!galeraAllowedStates.contains(rs.getString(2))) {
                        throw this.exceptionFactory.create(String.format("fail to validate Galera state (State is %s)", rs.getString(2)));
                    }
                    res.remove(0);
                }
            }
            catch (SQLException sqlException) {
                if (this.conf.timezone() != null && !"disable".equalsIgnoreCase(this.conf.timezone())) {
                    throw this.exceptionFactory.create(String.format("Setting configured timezone '%s' fail on server.\nLook at https://mariadb.com/kb/en/mysql_tzinfo_to_sql/ to load tz data on server, or set timezone=disable to disable setting client timezone.", this.conf.timezone()));
                }
                throw this.exceptionFactory.create("Initialization command fail", "08000", sqlException);
            }
        }
    }

    public String createSessionVariableQuery(String serverTz) {
        ArrayList<String> sessionCommands = new ArrayList<String>();
        if (this.conf.autocommit() != null) {
            sessionCommands.add("autocommit=" + (this.conf.autocommit() != false ? "1" : "0"));
        }
        if (this.conf.sessionVariables() != null) {
            sessionCommands.add(Security.parseSessionVariables(this.conf.sessionVariables()));
        }
        if (this.conf.timezone() != null && !"disable".equalsIgnoreCase(this.conf.timezone())) {
            boolean mustSetTimezone = true;
            ZoneId clientZoneId = ZoneId.of(this.conf.timezone()).normalized();
            try {
                if (ZoneId.of(serverTz).normalized().equals(clientZoneId) || ZoneId.of(serverTz, ZoneId.SHORT_IDS).equals(clientZoneId)) {
                    mustSetTimezone = false;
                }
            }
            catch (ZoneRulesException zoneRulesException) {
                // empty catch block
            }
            if (mustSetTimezone) {
                if (clientZoneId.getRules().isFixedOffset()) {
                    ZoneOffset zoneOffset = clientZoneId.getRules().getOffset(Instant.now());
                    sessionCommands.add("time_zone='" + zoneOffset.getId() + "'");
                } else {
                    sessionCommands.add("time_zone='" + this.conf.timezone() + "'");
                }
            }
        }
        if (this.conf.transactionIsolation() != null) {
            int major = this.context.getVersion().getMajorVersion();
            if (!this.context.getVersion().isMariaDBServer() && (major >= 8 && this.context.getVersion().versionGreaterOrEqual(8, 0, 3) || major < 8 && this.context.getVersion().versionGreaterOrEqual(5, 7, 20))) {
                sessionCommands.add("transaction_isolation='" + this.conf.transactionIsolation().getValue() + "'");
            } else {
                sessionCommands.add("tx_isolation='" + this.conf.transactionIsolation().getValue() + "'");
            }
        }
        if (!sessionCommands.isEmpty()) {
            return "set " + sessionCommands.stream().collect(Collectors.joining(","));
        }
        return null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
    }

    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            if (logger.isDebugEnabled() && message.description() != null) {
                logger.debug("execute query: {}", message.description());
            }
            return message.encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            if (ioException instanceof MaxAllowedPacketException) {
                if (((MaxAllowedPacketException)ioException).isMustReconnect()) {
                    this.destroySocket();
                    throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", ioException);
                }
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", ioException);
            }
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, boolean canRedo) throws SQLException {
        return this.execute(message, null, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, boolean canRedo) throws SQLException {
        return this.execute(message, stmt, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        ArrayList<Completion> results = new ArrayList<Completion>();
        int readCounter = 0;
        int[] responseMsg = new int[messages.length];
        try {
            if (this.disablePipeline) {
                for (readCounter = 0; readCounter < messages.length; ++readCounter) {
                    results.addAll(this.execute(messages[readCounter], stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo));
                }
            } else {
                for (int i = 0; i < messages.length; ++i) {
                    responseMsg[i] = this.sendQuery(messages[i]);
                }
                while (readCounter < messages.length) {
                    ++readCounter;
                    for (int j = 0; j < responseMsg[readCounter - 1]; ++j) {
                        results.addAll(this.readResponse(stmt, messages[readCounter - 1], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                    }
                }
            }
            return results;
        }
        catch (SQLException sqlException) {
            if (!this.closed) {
                for (int i = readCounter; i < messages.length; ++i) {
                    for (int j = 0; j < responseMsg[i]; ++j) {
                        try {
                            results.addAll(this.readResponse(stmt, messages[i], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                            continue;
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                for (Completion result : results) {
                    if (!(result instanceof PrepareResultPacket) || !(stmt instanceof ServerPreparedStatement)) continue;
                    try {
                        ((PrepareResultPacket)result).decrementUse(this, (ServerPreparedStatement)stmt);
                    }
                    catch (SQLException sQLException) {}
                }
            }
            int batchUpdateLength = 0;
            for (ClientMessage message : messages) {
                batchUpdateLength += message.batchUpdateLength();
            }
            throw this.exceptionFactory.createBatchUpdate(results, batchUpdateLength, responseMsg, sqlException);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        int nbResp = this.sendQuery(message);
        if (nbResp == 1) {
            return this.readResponse(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        while (nbResp-- > 0) {
            this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
        return completions;
    }

    public List<Completion> readResponse(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        return completions;
    }

    public void readResponse(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(null, message, completions, 0, 0L, 1007, 1003, false);
    }

    @Override
    public void closePrepare(Prepare prepare) throws SQLException {
        this.checkNotClosed();
        try {
            new ClosePreparePacket(prepare.getStatementId()).encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.create("Socket error during post connection queries: " + ioException.getMessage(), "08000", ioException);
        }
    }

    @Override
    public void readStreamingResults(List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        if (this.streamStmt != null) {
            this.readResults(this.streamStmt, this.streamMsg, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
    }

    private void readResults(Statement stmt, ClientMessage message, List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        while ((this.context.getServerStatus() & 8) > 0) {
            completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        }
    }

    public Completion readPacket(ClientMessage message) throws SQLException {
        return this.readPacket(null, message, 0, 0L, 1007, 1003, false);
    }

    public Completion readPacket(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        try {
            boolean traceEnable = logger.isTraceEnabled();
            Completion completion = message.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, this.reader, this.writer, this.context, this.exceptionFactory, this.lock, traceEnable);
            if (completion instanceof StreamingResult && !((StreamingResult)completion).loaded()) {
                this.streamStmt = stmt;
                this.streamMsg = message;
            }
            return completion;
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            try {
                long maxCurrentMillis = System.currentTimeMillis() + 10L;
                this.socket.shutdownOutput();
                this.socket.setSoTimeout(3);
                InputStream is = this.socket.getInputStream();
                while (is.read() != -1 && System.currentTimeMillis() < maxCurrentMillis) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer.close();
            this.reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw this.exceptionFactory.create("Cannot abort the connection: null executor passed");
        }
        boolean lockStatus = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            logger.debug("aborting connection {}", this.context.getThreadId());
            if (!lockStatus) {
                try (StandardClient cli = new StandardClient(this.conf, this.hostAddress, new ReentrantLock(), true);){
                    cli.execute(new QueryPacket("KILL " + this.context.getThreadId()), false);
                }
                catch (SQLException sQLException) {}
            } else {
                try {
                    QuitPacket.INSTANCE.encode(this.writer, this.context);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.streamStmt != null) {
                this.streamStmt.abort();
            }
            this.closeSocket();
        }
        if (lockStatus) {
            this.lock.unlock();
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int milliseconds) throws SQLException {
        try {
            this.socketTimeout = milliseconds;
            this.socket.setSoTimeout(milliseconds);
        }
        catch (SocketException se) {
            throw this.exceptionFactory.create("Cannot set the network timeout", "42000", se);
        }
    }

    @Override
    public void close() {
        boolean locked = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            try {
                QuitPacket.INSTANCE.encode(this.writer, this.context);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeSocket();
        }
        if (locked) {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isPrimary() {
        return this.hostAddress.primary;
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public void reset() {
        this.context.resetStateFlag();
        this.context.resetPrepareCache();
    }
}

