/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark.cmd;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.cmd.HlUtils;
import java.io.IOException;
import java.util.List;

final class CodeBlockEmitter
implements BlockEmitter {
    private final String encoding;
    private final String program;

    public CodeBlockEmitter(String encoding, String program) {
        this.encoding = encoding;
        this.program = program;
    }

    private static void append(StringBuilder out, List<String> lines) {
        out.append("<pre class=\"pre_no_hl\">");
        for (String l : lines) {
            HlUtils.escapedAdd(out, l);
            out.append('\n');
        }
        out.append("</pre>");
    }

    @Override
    public void emitBlock(StringBuilder out, List<String> lines, String meta) {
        if (meta == null || meta.isEmpty()) {
            CodeBlockEmitter.append(out, lines);
        } else {
            try {
                out.append(HlUtils.highlight(lines, meta, this.program, this.encoding));
                out.append('\n');
            }
            catch (IOException e) {
                CodeBlockEmitter.append(out, lines);
            }
        }
    }
}

