/**
 * Cerca un account applicando il parametro di ricerca su username, email e partita iva
 * 
 * PARAMETRI
 * –––––––––
 * 1 - identificativo
 */

SELECT DISTINCT
	pojos.*,
	
	soggetti.Nominativo	AS	soggettoNominativo
	
FROM
	(SELECT 1 AS dummyField) AS dummyRecord

	-- parametro 1 - identificativo
	INNER JOIN	(SELECT ? AS valore)			AS par1			ON	1 = 1
	
	
	
	-- (•)
	INNER JOIN	{TABLE-Account}					AS	pojos		ON	1 = 1
	
	-- x1 soggetto collegato
	INNER JOIN	{TABLE-Soggetto}				AS	soggetti	ON	soggetti.id = pojos.idSoggetto
	
	-- xN campo aggiuntivo EMAIL principale
	-- potenzialmente potrebbero essere N, ma tendenzialmente sarà uno a causa del bit "principale"
	-- NON vanno riportati nella SELECT clause, altrimenti invalida la direttiva DISTINCT
	LEFT JOIN	{TABLE-SoggettoCampoAggiuntivo}	AS	sca			ON	sca.idSoggetto = soggetti.id
																	AND
																	sca.principale
	LEFT JOIN	{TABLE-CampoAggiuntivo}			AS	ca			ON	ca.id = sca.idCampoAggiuntivo
																	AND
																	ca.codice = "EMAIL"

WHERE
	pojos.username = par1.valore
	OR
	soggetti.codiceFiscale = par1.valore
	OR
	soggetti.partitaIva = par1.valore
	OR
	sca.valore = par1.valore