/**
 * Ritorna il valore massimo per il campo numero per i documenti di un dato tipo, cedente e anno 
 * 
 * PARAMETRI
 * –––––––––
 * 1 - id del cedente
 * 2 - tipo
 * 3 - anno
 */

SELECT
	COALESCE(MAX(COALESCE(documenti.numero, 0)), 0) + 1
	
FROM
	-- x1 record con i parametri
	(
		SELECT
			? AS idCedente,	-- #1 id del cedente
			? AS tipo,		-- #2 tipo
			? AS anno		-- #3 anno
	) AS parametri

	-- (•)
	INNER JOIN	{TABLE-Documento}	AS	documenti	ON	documenti.idCedente = parametri.idCedente
														AND
														documenti.tipo = parametri.tipo
														AND
														documenti.anno = parametri.anno 