/**
 * Ritorna il valore massimo per il campo numero per i documenti di un dato tipo e committente 
 * 
 * PARAMETRI
 * –––––––––
 * 1 - id del cedente
 * 2 - tipo
 */

SELECT
	COALESCE(MAX(COALESCE(documenti.numero, 0)), 0) + 1
	
FROM
	-- x1 record con i parametri
	(
		SELECT
			? AS idCommittente,	-- #1 id del committente
			? AS tipo			-- #2 tipo
	) AS parametri

	-- (•)
	INNER JOIN	{TABLE-Documento}	AS	documenti	ON	documenti.idCommittente = parametri.idCommittente
														AND
														documenti.tipo = parametri.tipo
