/**
 * Ritorna il valore massimo per il campo numero per i documenti di un dato tipo e anno 
 * 
 * PARAMETRI
 * –––––––––
 * 1 - tipo
 * 2 - anno
 */

SELECT
	COALESCE(MAX(COALESCE(documenti.numero, 0)), 0) + 1
	
FROM
	-- x1 record con i parametri
	(
		SELECT
			? AS tipo,	-- #1 tipo
			? AS anno	-- #2 anno
	) AS parametri

	-- (•)
	INNER JOIN	{TABLE-Documento}	AS	documenti	ON	documenti.tipo = parametri.tipo
														AND
														documenti.anno = parametri.anno 