/**
 * Torna i tipi di legame instaurati da un dato soggetto
 * 
 * PARAMETRI
 * –––––––––
 * 1 - id del soggetto da cercare
 */
SELECT DISTINCT
	pojos.*
FROM
	(SELECT 1 AS dummyField) AS dummyRecord
	
	-- x1 - seleziono il soggetto richiesto
	INNER JOIN	{TABLE-Soggetto}		AS	s		ON	s.id = ? -- #1 - id del soggetto
	
	-- xN - seleziono i legami del soggetto come parte 1 o 2
	INNER JOIN	{TABLE-SoggettiLegame}	AS	sl		ON	(
															sl.idSoggetto1 = s.id
															OR
															sl.idSoggetto2 = s.id
														)
	-- x1 - seleziono il legame
	INNER JOIN	{TABLE-Legame}			AS	pojos	ON	pojos.id = sl.idLegame