/**
 * Torna i legami di un dato soggetto per un legame in cui il soggetto è la parte 1
 * 
 * PARAMETRI
 * –––––––––
 * 1 - id del soggetto da cercare
 * 2 - codice del legame
 */
SELECT
	pojos.*
FROM
	(SELECT 1 AS dummyField) AS dummyRecord

	-- x1 - seleziono il soggetto richiesto
	INNER JOIN	{TABLE-Soggetto}		AS	s		ON	s.id = ? -- #1 - id del soggetto
	
	-- x1 - seleziono il legame richiesti
	INNER JOIN	{TABLE-Legame}			AS	l		ON	l.codice = ?	-- #2 - codice del legame
	
	-- xN - seleziono i legami corrispondenti
	INNER JOIN	{TABLE-SoggettiLegame}	AS	pojos	ON	pojos.idLegame = l.id
														AND
														pojos.idSoggetto1 = s.id
