/**
 * Torna i soggetti legati ad un dato soggetto.
 * Il soggetto dato può essere sia il soggetto1 che il soggetto2.
 * 
 * PARAMETRI
 * –––––––––
 * 1 - id del soggetto da cercare
 */
SELECT DISTINCT
	pojos.*
	
FROM
	-- x1 record con i parametri
	(
		SELECT
			? AS idSoggetto	-- #1 id del soggetto
	) AS parametri

	-- xN - seleziono i legami corrispondenti
	INNER JOIN	{TABLE-SoggettiLegame}	AS	sl		ON	sl.idSoggetto1 = parametri.idSoggetto
														OR
														sl.idSoggetto2 = parametri.idSoggetto
	
	-- (•) - soggetto2 del legame
	INNER JOIN	{TABLE-Soggetto}		AS	pojos	ON	(
															pojos.id = sl.idSoggetto1
															OR
															pojos.id = sl.idSoggetto2
														)
														AND
														pojos.id != parametri.idSoggetto
														