/**
 * Torna i soggetti legati ad un dato soggetto con un dato legame.
 * Il soggetto dato è il soggetto1 nel legame, quindi i soggetti da tornare sono i soggetti2 legati al soggetto dato.
 * 
 * PARAMETRI
 * –––––––––
 * 1 - id del soggetto da cercare
 * 2 - codice del legame
 */
SELECT
	pojos.*
	
FROM
	-- x1 record con i parametri
	(
		SELECT
			? AS idSoggetto,	-- #1 id del soggetto
			? AS legameCodice	-- #2 codice del legame
	) AS parametri

	-- x1 - seleziono il legame richiesti
	INNER JOIN	{TABLE-Legame}			AS	l		ON	l.codice = parametri.legameCodice
	
	-- xN - seleziono i legami corrispondenti
	INNER JOIN	{TABLE-SoggettiLegame}	AS	sl		ON	sl.idLegame = l.id
														AND
														sl.idSoggetto1 = parametri.idSoggetto
	
	-- (•) - soggetto2 del legame
	INNER JOIN	{TABLE-Soggetto}		AS	pojos	ON	pojos.id = sl.idSoggetto2