/**
 * Torna i soggetti legati ad un dato soggetto.
 * Il soggetto dato è il soggetto2 nel legame, quindi i soggetti da tornare sono i soggetti1 legati al soggetto dato.
 * 
 * PARAMETRI
 * –––––––––
 * 1 - id del soggetto da cercare
 */
SELECT DISTINCT
	pojos.*
	
FROM
	-- x1 record con i parametri
	(
		SELECT
			? AS idSoggetto	-- #1 id del soggetto
	) AS parametri

	-- xN - seleziono i legami corrispondenti
	INNER JOIN	{TABLE-SoggettiLegame}	AS	sl		ON	sl.idSoggetto2 = parametri.idSoggetto
	
	-- (•) - soggetto1 del legame
	INNER JOIN	{TABLE-Soggetto}		AS	pojos	ON	pojos.id = sl.idSoggetto1