
SELECT DISTINCT
	pojos.*,
	t.predefinito,
	
	indirizzi.pattern,
	indirizzi.idNazione,
	indirizzi.percorso,
	indirizzi.civico,
	indirizzi.localita,
	indirizzi.frazione,
	indirizzi.cap,
	indirizzi.provincia,
	indirizzi.regione,
	indirizzi.latitudine,
	indirizzi.longitudine,
	
	nazioni.codice AS nazioneCodice,
	nazioni.lingua AS nazioneLingua
FROM
	(SELECT 1 AS dummyField) AS dummyRecord
	
	INNER JOIN	{TABLE-Soggetto}				AS	pojos		ON	1 = 1
	INNER JOIN	{TABLE-Titolare}				AS	t			ON	t.id = pojos.id 	
	
	-- indirizzo principale
	LEFT JOIN	{TABLE-SoggettoIndirizzo}		AS	si			ON	si.idSoggetto = pojos.id
																	AND
																	si.principale
	LEFT JOIN	{TABLE-Indirizzo}				AS	indirizzi	ON	si.idIndirizzo = indirizzi.id
	LEFT JOIN	{TABLE-Nazione}					AS	nazioni		ON	indirizzi.idNazione = nazioni.id
	
	-- join con i campi aggiuntivi principali unicamente per poter filtrare
	-- NON vanno riportati nella SELECT clause, altrimenti invalida la direttiva DISTINCT
	LEFT JOIN	{TABLE-SoggettoCampoAggiuntivo}	AS	sca			ON	sca.idSoggetto = pojos.id
																	AND
																	sca.principale