<%@ include file="/_core/system/directives.jsp" %>

<%@ page import="it.triware.i18n.Translator" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	address_



	PARAMETRI
	–––––––––
	class		→ classe da aggiungere al contenitore address-box
	mapping		→ (default = "indirizzo") campo a cui collegare i dati raccolti da questa pagina
	required	→ (boolean default=false) indica che pattern, percorso, cap, località e nazione devono essere inseriti
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%
	pageContext.setAttribute("GOOGLE_KEY", Application.getGoogleKey());
%>

<c:set scope="page" var="mapping" value="${empty param.address_mapping ? 'indirizzo' : param.address_mapping}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%-- il campo INDIRIZZO_COMPLETO con automatismo GoogleMaps viene attivato solo in presenza della chiave GOOGLE --%>
<c:if test="${not empty GOOGLE_KEY}">
	<c:set scope="page" var="indirizzoFontSize" value="gpro-font-size-small" />
	<c:set scope="page" var="indirizzoBoxTmpId" value="${f:lostId()}" />
	<div class="${param.address_class}">
		<%-- pattern (indirizzo) --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="x2" />
			<jsp:param name="input_mapping" value="${mapping}.pattern" />
			<jsp:param name="input_customType" value="address" />
			<jsp:param name="input_required" value="${param.address_required == 'true' ? true : false}" />
			<jsp:param name="input_rel" value="${indirizzoBoxTmpId}" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Indirizzo_completo')}" />
		</jsp:include>
	</div>
</c:if>
	
<div
	id="${indirizzoBoxTmpId}"
	class="	address-box
			${' '}
			${param.address_class}
			${' '}
			${not empty GOOGLE_KEY ? 'ui-helper-hidden' : ' '}"
>
	<html:input type="hidden" mapping="${mapping}.id" />
	<html:input type="hidden" mapping="${mapping}.latitudine" />
	<html:input type="hidden" mapping="${mapping}.longitudine" />

	<div>
		<%-- percorso --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-flex-grow" />
			<jsp:param name="input_classField" value="${indirizzoFontSize}" />
			<jsp:param name="input_mapping" value="${mapping}.percorso" />
			<jsp:param name="input_required" value="${param.address_required == 'true' ? true : false}" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Indirizzo')}" />
		</jsp:include>

		<%-- civico --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="x1_2" />
			<jsp:param name="input_classField" value="${indirizzoFontSize}" />
			<jsp:param name="input_mapping" value="${mapping}.civico" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Civico')}" />
		</jsp:include>
	</div>

	<div>
		<%-- cap --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="x1_2" />
			<jsp:param name="input_classField" value="${indirizzoFontSize}" />
			<jsp:param name="input_mapping" value="${mapping}.cap" />
			<jsp:param name="input_required" value="${param.address_required == 'true' ? true : false}" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Cap')}" />
		</jsp:include>

		<%-- località --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-flex-grow" />
			<jsp:param name="input_classField" value="${indirizzoFontSize}" />
			<jsp:param name="input_mapping" value="${mapping}.localita" />
			<jsp:param name="input_required" value="${param.address_required == 'true' ? true : false}" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Città')}" />
		</jsp:include>
	</div>

	<div>
		<%-- frazione --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="x2" />
			<jsp:param name="input_classField" value="${indirizzoFontSize}" />
			<jsp:param name="input_mapping" value="${mapping}.frazione" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Frazione')}" />
		</jsp:include>
	</div>
	
	<div>
		<%-- provincia --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="x1_2" />
			<jsp:param name="input_classField" value="${indirizzoFontSize}" />
			<jsp:param name="input_mapping" value="${mapping}.provincia" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Provincia')}" />
		</jsp:include>

		<%-- regione --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-flex-grow" />
			<jsp:param name="input_classField" value="${indirizzoFontSize}" />
			<jsp:param name="input_mapping" value="${mapping}.regione" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Regione')}" />
		</jsp:include>
	</div>

	<div>
		<%-- nazione --%>
		<c:set scope="page" var="options">
			<c:forEach items="${Translator.getNazioni()}" var="nazione">
				<c:set scope="page" var="nazioneNome" value="${f:displayCountry2(nazione.codice, LOCALE)}" />
				<c:if test="${not empty nazioneNome}">
					${nazione.id},rel=${nazione.codice}|${nazioneNome}||
				</c:if>
			</c:forEach>
		</c:set>
		<jsp:include page="/_core/system/include/select.html.jsp">
			<jsp:param name="select_classBox" value="x2" />
			<jsp:param name="select_classField" value="${indirizzoFontSize}" />
			<jsp:param name="select_mapping" value="${mapping}.idNazione" />
			<jsp:param name="select_firstEmpty" value="${param.address_required == 'true' ? false : true}" />
			<jsp:param name="select_caption" value="${f:message(LOCALE, 'Nazione')}" />
			<jsp:param name="select_options" value="${options}" />
		</jsp:include>
	</div>
</div>