<%@ include file="/_core/system/directives.jsp" %>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	button_



	PARAMETRI
	–––––––––
	id					→ (default=temporary id) id da assegnare al pulsante
	class				→ classe da assegnare al pulsante
	colorClass			→ classe specifica per il colore (es. mdc-color--black)
	textClass			→ classe specifica per il testo (applicata allo span interno)
	imgClass			→ classe specifica per l'immagine (applicata al tag img interno)
	color				→ colore da usare come colore principale tramite attributo CSS
	icon				→ icona da assegnare al pulsante (chiave testuale delle icone previste dalla libreria)
	icon_lib_fa			→ libreria fontawesome
	text				→ testo del pulsante
	tooltip				→ tooltip del pulsante
	tooltipClass		→ classe del tooltip
	disabled			→ (default=false) stato disabled del pulsante
	download			→ (default=false) valore da assegnare all'attributo download del pulsante
	rel					→ valore da assegnare all'attributo rel del pulsante
	tag					→ valore da assegnare all'attributo tag del pulsante
	action				→ valore da assegnare all'attributo action del pulsante
	step				→ valore da assegnare all'attributo step del pulsante
	src					→ valore da assegnare all'attributo src dell'immagine da includere nel pulsante
	useImgTag			→ valore che indica se usare un tag img per l'immagine oppure uno span con background
	imgFirst			→ (boolean default=true) indica se posizionare l'immagine o l'icona prima del testo
	fab					→ (boolean default=false) indica se il pulsante deve essere un fab
	raised				→ (boolean default=false) indica se applicare la classe per i pulsanti raised
	
	checkRequiredFields → (boolean) controllo dei campi obbligatori
	validation 			→ (boolean) invocazione della eventuale procedura di validazione (oltre al controllo dei campi obbligatori)
--%>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%-- style da applicare se viene indicato un colore direttamente (es. #123456, red...) --%>
<c:if test="${not empty param.button_color}">
	<c:set scope="page" var="style" value="color:${param.button_color}" />
</c:if>

<%-- immagine da da un src usando un tag img o uno span con background --%>
<c:if test="${not empty param.button_src}">
	<c:set scope="page" var="buttonImage">
		<c:choose>
			<c:when test="${empty param.button_useImgTag || param.button_useImgTag == 'true'}">
				<img src="${param.button_src}" class="${param.button_imgClass}" />
			</c:when>
			<c:otherwise>
				<span style="background-image:url('${param.button_src}')" class="img-replacement ${param.button_imgClass}"></span>
			</c:otherwise>
		</c:choose>
	</c:set>
</c:if>

<%-- calcolo il "tipo", cioè la classe principale --%>
<c:choose>
	<%-- FAB --%>
	<c:when test="${param.button_fab == 'true'}">
		<c:set scope="page" var="buttonType" value="mdc-fab material-icons" />
	</c:when>
	<%-- pulsante "icona", cioè senza il testo e con una icona --%>
	<c:when test="${empty param.button_text}">
		<c:set scope="page" var="buttonType" value="mdc-icon-button material-icons" />
	</c:when>
	<%-- default --%>
	<c:otherwise>
		<c:set scope="page" var="buttonType" value="mdc-button" />
	</c:otherwise>
</c:choose>

<c:set scope="page" var="id" value="${not empty param.button_id ? param.button_id : f:lostId()}" />
<html:button
	id			= "${id}"
	classname	= "	${buttonType}
					${param.button_raised == 'true' ? 'mdc-button--raised' : ''}
					${param.button_colorClass}
					${param.button_class}"
	rel			= "${param.button_rel}"
	tag			= "${param.button_tag}"
	step		= "${param.button_step}"
	action		= "${param.button_action}"
	title		= "${param.button_tooltip}"
	disabled	= "${empty param.button_disabled || param.button_disabled == 'false' ? false : true}"
	download	= "${empty param.button_download || param.button_download == 'false' ? false : true}"
	
	style		= "${style}"
	validation	= "${param.button_validation}"
	checkRequiredFields = "${param.button_checkRequiredFields}"
	>

	<div class="mdc-button__ripple"></div>

	<c:choose>
		<c:when test="${empty param.button_imgFirst || param.button_imgFirst == 'true'}">
			<%-- icon or img --%>
			<c:if test="${not empty param.button_icon}">
				<c:choose>
					<c:when test="${not empty param.button_text || param.button_icon_lib_fa == 'true'}">
						<jsp:include page="/_core/system/include/icon.html.jsp">
							<jsp:param name="icon_class" value="mdc-button__icon" />
							<jsp:param name="icon_lib_fa" value="${param.button_icon_lib_fa}" />
							<jsp:param name="icon_icon" value="${param.button_icon}" />
						</jsp:include>
					</c:when>
					<c:otherwise>${param.button_icon}</c:otherwise>
				</c:choose>
			</c:if>
			<c:if test="${not empty param.button_src}">${buttonImage}</c:if>
			
			<%-- text --%>
			<c:if test="${not empty param.button_text}"><span class="mdc-button__label ${param.button_textClass}">${param.button_text}</span></c:if>
		</c:when>
		
		<c:otherwise>
			<%-- text --%>
			<c:if test="${not empty param.button_text}"><span class="mdc-button__label ${param.button_textClass}">${param.button_text}</span></c:if>
			
			<%-- icon or img --%>
			<c:if test="${not empty param.button_icon}">
				<c:choose>
					<c:when test="${not empty param.button_text || param.button_icon_lib_fa == 'true'}">
						<jsp:include page="/_core/system/include/icon.html.jsp">
							<jsp:param name="icon_class" value="mdc-button__icon" />
							<jsp:param name="icon_lib_fa" value="${param.button_icon_lib_fa}" />
							<jsp:param name="icon_icon" value="${param.button_icon}" />
						</jsp:include>
					</c:when>
					<c:otherwise>${param.button_icon}</c:otherwise>
				</c:choose>
			</c:if>
			<c:if test="${not empty param.button_src}">${buttonImage}</c:if>
		</c:otherwise>
	</c:choose>
</html:button>