<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	check_
	
	
	
	PARAMETRI
	–––––––––
	idBox			→ id del contenitore top (g•PRO)
	classBox		→ classe del contenitore top (g•PRO)
	
	idField			→ id del contenitore intermedio (Material)
	classField		→ classe del contenitore top (Material)
	
	id				→ id
	caption			→ etichetta
	class			→ class
	checked			→ checked (se forzato tramite il parametro setValue)
	dataTransform	→ dataTransform (es. MD5)
	dataBadge		→ dataBadge
	icon			→ icona
	icon_lib_fa		→ libreria fontawesome 
	mapping			→ mapping
	required		→ (boolean) required (default = false)
	readOnly		→ (boolean) readOnly (default = false)
	rows			→ (integer) rows (default = 3)
	tag				→ tag
	title			→ tooltip (mappato tramite l'attributo title del contenitore)
	value			→ value
	
	setChecked		→ (boolean) indica se attribuire forzosamente un valore all'oggetto o lasciare che venga recuperato dal mapping	
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="checkId" value="${empty param.check_id ? f:lostId() : param.check_id}" />

<div
	id		= "${param.check_idBox}"
	class	= "gpro-mdc-text-field-box gpro-mdc-text-field-box--check ${param.check_classBox}"
	title	= "${param.check_title}">

	<div class="mdc-form-field mdc-touch-target-wrapper">
		<div
			id		= "${param.check_idField}"
			class	="mdc-checkbox mdc-checkbox--touch ${param.check_classField}">
			
			<c:choose>
				<c:when test="${param.check_setChecked == 'true' || not empty param.check_checked}">
					<html:input
						checked		= "${param.check_checked}"
						
						type		= "checkbox"
						
						id			= "${checkId}"
						mapping		= "${param.check_mapping}"
						tag			= "${param.check_tag}"
						disabled	= "${param.check_disabled}"
						value		= "${param.check_value}"
						classname	= "mdc-checkbox__native-control ${param.check_class}" />
				</c:when>
				
				<c:otherwise>
					<html:input
						type		= "checkbox"
						
						id			= "${checkId}"
						mapping		= "${param.check_mapping}"
						tag			= "${param.check_tag}"
						disabled	= "${param.check_disabled}"
						value		= "${param.check_value}"
						classname	= "mdc-checkbox__native-control ${param.check_class}" />
				</c:otherwise>
			</c:choose>
    		
    		<div class="mdc-checkbox__background">
				<svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
					<path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
				</svg>
				<div class="mdc-checkbox__mixedmark"></div>
			</div>
    		<div class="mdc-checkbox__ripple"></div>
		</div>
	
		<c:if test="${not empty param.check_caption || not empty param.check_icon}">
			<label for="${checkId}" class="gpro-mdc-text-field-box--checkbox__label">
				<c:if test="${not empty param.check_icon}">
					<jsp:include page="/_core/system/include/icon.html.jsp">
						<jsp:param name="icon_lib_fa" value="${param.check_icon_lib_fa}" />
						<jsp:param name="icon_icon" value="${param.check_icon}" />
					</jsp:include>
				</c:if>
				<span>${param.check_caption}</span>
			</label>
		</c:if>
	</div>
</div>