<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	chip_
	
	
	
	PARAMETRI
	–––––––––
	id				→ id
	class			→ class
	text			→ testo
	leading_icon	→ icona precedente al testo
	trailing_icon	→ icona successiva al testo
	removable		→ (default false) indica che la chip può essere rimossa
	inner			→ testo o codice da includere nel chip
	tag				→ tag
	rel				→ rel
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div id="${param.chip_id}" class="mdc-chip ${' '} ${param.chip_class} ${' '} ${param.chip_removable == 'true' ? ' gpro-on-hover-container row-container ' : ''}" tag="${param.chip_tag}" rel="${param.chip_rel}">
	<c:if test="${not empty param.chip_inner}">
		${param.chip_inner}
	</c:if>
	
	<div class="mdc-chip__ripple"></div>
	
	<%-- leading icon --%>
	<c:if test="${not empty param.chip_leading_icon}">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_class" value="mdc-chip__icon mdc-chip__icon--leading ${param.chip_removable == 'true' ? ' gpro-displaynone-on-hover ' : ''}" />
			<jsp:param name="icon_icon" value="${param.chip_leading_icon}" />
		</jsp:include>

		<%-- icona alternativa (visibile on hover) per la rimozione del chip --%>
		<c:if test="${param.chip_removable == 'true'}">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_class" value="mdc-chip__icon mdc-chip__icon--leading gpro-display-on-hover row-container-remove" />
				<jsp:param name="icon_icon" value="cancel" />
			</jsp:include>
		</c:if>
	</c:if>
  
  	<%-- testo con tooltip (title) perché potrebbe essere tagliato per eccessiva lunghezza --%>
    <span class="mdc-chip__primary-action">
      <span class="mdc-chip__text" title="${param.chip_text}">${param.chip_text}</span>
    </span>

	<%-- trailing icon --%>
	<c:if test="${not empty param.chip_trailing_icon}">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_class" value="mdc-chip__icon mdc-chip__icon--trailing" />
			<jsp:param name="icon_icon" value="${param.chip_trailing_icon}" />
		</jsp:include>
	</c:if>
</div>