<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	input_
	
	
	
	PARAMETRI
	–––––––––
	idBox			→ id del contenitore top (g•PRO)
	classBox		→ classe del contenitore top (g•PRO)
	
	idField			→ id del contenitore intermedio (Material)
	classField		→ classe del contenitore top (Material)
	
	id				→ id
	caption			→ etichetta
	class			→ class
	customType		→ customtype
	dataTransform	→ dataTransform (es. MD5)
	dataBadge		→ dataBadge
	disabled		→ (boolean) disabled (default = false)
	label			→ label
	mapping			→ mapping
	maxLength		→ maxlength
	name			→ name
	placeHolder		→ placeholder
	readOnly		→ (boolean) readOnly (default = false)
	rel				→ rel
	required		→ (boolean) required (default = false)
	ripple			→ (boolean) ripple (default = true)
	title			→ tooltip (mappato tramite l'attributo title del contenitore)
	tag				→ tag
	type			→ type (default = text)
	value			→ valore (se forzato tramite il parametro setValue)
	
	buttons			→ pulsanti
	setValue		→ (boolean) indica se attribuire forzosamente un valore all'oggetto o lasciare che venga recuperato dal mapping	
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="hasLabel" value="${not empty param.input_caption}" />
<c:set scope="page" var="hasRipple" value="${empty param.input_ripple || param.input_ripple == 'true' || param.input_ripple == 'true'}" />
<c:set scope="page" var="dataTransform" value="${not empty param.input_dataTransform ? param.input_dataTransform : (param.input_type == 'password' ? 'MD5' : '')}" />

<c:if test="${not empty dataTransform}">
	<c:set scope="page" var="inputExtraClass" value="data-transform__${dataTransform}" />
</c:if>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	id="${param.input_idBox}"
	class="gpro-mdc-text-field-box ${param.input_classBox}"
	title="${param.input_title}">
	
	<label
		id="${param.input_idField}"
		class="	mdc-text-field
				${' '}
				${hasLabel ? '' : ' mdc-text-field--no-label '}
				${' '}
				${hasRipple ? '' : ' mdc-text-field--no-ripple '}
				${' '}
				${param.input_classField}
				"
		data-mdc-auto-init="MDCTextField">
		
		<span class="mdc-text-field__ripple"></span>
		
		<c:choose>
			<c:when test="${param.input_setValue == 'true'}">
				<html:input
					value			= "${param.input_value}"
				
					id				= "${param.input_id}"
					name			= "${param.input_name}"
					mapping			= "${param.input_mapping}"
					label			= "${param.input_label}"
					type			= "${param.input_type}"
					rel				= "${param.input_rel}"
					readonly		= "${empty param.input_readOnly ? false : param.input_readOnly}"
					required		= "${empty param.input_required ? false : param.input_required}"
					disabled		= "${empty param.input_disabled ? false : param.input_disabled}"
					maxlength		= "${param.input_maxLength}"
					tag				= "${param.input_tag}"
					dataTransform	= "${dataTransform}"
					dataBadge		= "${param.input_dataBadge}"
					customtype		= "${param.input_customType}"
					placeholder		= "${param.input_placeHolder}"
					classname		= "mdc-text-field__input ${param.input_class} ${inputExtraClass}" />
			</c:when>
			
			<c:otherwise>
				<html:input
					id				= "${param.input_id}"
					name			= "${param.input_name}"
					mapping			= "${param.input_mapping}"
					label			= "${param.input_label}"
					type			= "${param.input_type}"
					rel				= "${param.input_rel}"
					required		= "${empty param.input_required ? false : param.input_required}"
					readonly		= "${empty param.input_readOnly ? false : param.input_readOnly}"
					disabled		= "${empty param.input_disabled ? false : param.input_disabled}"
					maxlength		= "${param.input_maxLength}"
					tag				= "${param.input_tag}"
					dataTransform	= "${dataTransform}"
					dataBadge		= "${param.input_dataBadge}"
					customtype		= "${param.input_customType}"
					placeholder		= "${param.input_placeHolder}"
					classname		= "mdc-text-field__input ${param.input_class} ${inputExtraClass}" />
			</c:otherwise>
		</c:choose>
		
		<c:if test="${hasLabel}"><span class="mdc-floating-label">${param.input_caption}</span></c:if>
		
		<span class="mdc-line-ripple"></span>
		
		<c:if test="${not empty param.input_buttons}">
			<div class="gpro-inputbox-buttons">${param.input_buttons}</div>
		</c:if>
	</label>
</div>