<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	radio_
	
	
	
	PARAMETRI
	–––––––––
	idBox			→ id del contenitore top (g•PRO)
	classBox		→ classe del contenitore top (g•PRO)
	
	idField			→ id del contenitore intermedio (Material)
	classField		→ classe del contenitore top (Material)
	
	id				→ id
	caption			→ etichetta
	class			→ class
	radioed			→ radioed (se forzato tramite il parametro setValue)
	dataTransform	→ dataTransform (es. MD5)
	dataBadge		→ dataBadge
	icon			→ icona
	icon_lib_fa		→ libreria fontawesome 
	mapping			→ mapping
	required		→ (boolean) required (default = false)
	readOnly		→ (boolean) readOnly (default = false)
	rows			→ (integer) rows (default = 3)
	tag				→ tag
	title			→ tooltip (mappato tramite l'attributo title del contenitore)
	value			→ valore (se forzato tramite il parametro setValue)
	
	setChecked		→ (boolean) indica se attribuire forzosamente un valore all'oggetto o lasciare che venga recuperato dal mapping
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="radioId" value="${empty param.radio_id ? f:lostId() : param.radio_id}" />

<div
	id		= "${param.radio_idBox}"
	class	= "gpro-mdc-text-field-box gpro-mdc-text-field-box--radio ${param.radio_classBox}"
	title	= "${param.radio_title}">

	<div class="mdc-form-field mdc-touch-target-wrapper">
		<div
			id		= "${param.radio_idField}"
			class	="mdc-radio mdc-radio--touch ${param.radio_classField}">
			
			<c:choose>
				<c:when test="${param.radio_setChecked == 'true'}">
					<html:input
						checked		= "${param.radio_checked}"
						
						type		= "radio"
						
						id			= "${radioId}"
						value		= "${param.radio_value}"
						mapping		= "${param.radio_mapping}"
						tag			= "${param.radio_tag}"
						readonly	= "${param.radio_readOnly}"
						disabled	= "${param.radio_disabled}"
						classname	= "mdc-radio__native-control ${param.radio_class}" />
				</c:when>
				
				<c:otherwise>
					<html:input
						type		= "radio"
						
						id			= "${radioId}"
						value		= "${param.radio_value}"
						mapping		= "${param.radio_mapping}"
						tag			= "${param.radio_tag}"
						readonly	= "${param.radio_readOnly}"
						disabled	= "${param.radio_disabled}"
						classname	= "mdc-radio__native-control ${param.radio_class}" />
				</c:otherwise>
			</c:choose>
    		
    		<div class="mdc-radio__background">
				<div class="mdc-radio__outer-circle"></div>
				<div class="mdc-radio__inner-circle"></div>
			</div>
			<div class="mdc-radio__ripple"></div>
		</div>
	
		<c:if test="${not empty param.radio_caption || not empty param.radio_icon}">
			<label for="${radioId}" class="gpro-mdc-text-field-box--radio__label">
				<c:if test="${not empty param.radio_icon}">
					<jsp:include page="/_core/system/include/icon.html.jsp">
						<jsp:param name="icon_lib_fa" value="${param.radio_icon_lib_fa}" />
						<jsp:param name="icon_icon" value="${param.radio_icon}" />
					</jsp:include>
				</c:if>
				<span>${param.radio_caption}</span>
			</label>
		</c:if>
	</div>
</div>
