<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	select_
	
	
	
	PARAMETRI
	–––––––––
	idBox			→ id del contenitore top (g•PRO)
	classBox		→ classe del contenitore top (g•PRO)
	
	idField			→ id del contenitore intermedio (Material)
	classField		→ classe del contenitore top (Material)
	
	id				→ id
	caption			→ etichetta
	class			→ classname
	dataTransform	→ dataTransform (es. MD5)
	dataBadge		→ dataBadge
	disabled		→ (boolean) disabled (default = false)
	sorted			→ (boolean) sorted (default = true)
	firstEmpty		→ (boolean) firstempty (default = false)
	firstEmptyLabel	→ first empty label
	mapping			→ mapping
	required		→ (boolean) required (default = false)
	title			→ tooltip (mappato tramite l'attributo title del contenitore)
	value			→ valore (se forzato tramite il parametro setValue)
	
	setValue		→ (boolean) indica se attribuire forzosamente un valore all'oggetto o lasciare che venga recuperato dal mapping	
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="hasCaption" value="${not empty param.select_caption}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	id		= "${param.select_idBox}"
	class	= "gpro-mdc-text-field-box ${param.select_classBox}"
	title	= "${param.select_title}">
	
	<label
		id					= "${param.select_idField}"
		class				= "mdc-text-field ${hasCaption ? '' : ' mdc-text-field--no-label '} ${param.select_classField}"
		data-mdc-auto-init	= "MDCTextField">
		
		<span class="mdc-text-field__ripple"></span>
		
		<c:choose>
			<c:when test="${param.select_setValue == 'true'}">
				<html:select
					value			= "${param.select_value}"
				
					id				= "${param.select_id}"
					mapping			= "${param.select_mapping}"
					required		= "${empty param.select_required ? false : param.select_required}"
					disabled		= "${empty param.select_disabled ? false : param.select_disabled}"
					sorted			= "${empty param.select_sorted ? true : param.select_sorted}"
					firstempty		= "${empty param.select_firstEmpty ? false : param.select_firstEmpty}"
					firstemptylabel	= "${param.select_firstEmptyLabel}"
					dataTransform	= "${param.select_dataTransform}"
					dataBadge		= "${param.select_dataBadge}"
					options			= "${param.select_options}"
					classname		= "mdc-text-field__input ${param.select_class}" />
			</c:when>
				
			<c:otherwise>
				<html:select
					id				= "${param.select_id}"
					mapping			= "${param.select_mapping}"
					required		= "${empty param.select_required ? false : param.select_required}"
					disabled		= "${empty param.select_disabled ? false : param.select_disabled}"
					sorted			= "${empty param.select_sorted ? true : param.select_sorted}"
					firstempty		= "${empty param.select_firstEmpty ? false : param.select_firstEmpty}"
					firstemptylabel	= "${param.select_firstEmptyLabel}"
					dataTransform	= "${param.select_dataTransform}"
					dataBadge		= "${param.select_dataBadge}"
					options			= "${param.select_options}"
					classname		= "mdc-text-field__input ${param.select_class}" />
			</c:otherwise>
		</c:choose>
		
		<c:if test="${hasCaption}"><span class="mdc-floating-label">${param.select_caption}</span></c:if>
		
		<span class="mdc-line-ripple"></span>
		
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_class" value="mdc-select__dropdown-icon" />
			<jsp:param name="icon_icon" value="arrow_drop_down" />
		</jsp:include>
	</label>
</div>