<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	switch_
	
	
	
	PARAMETRI
	–––––––––
	idBox			→ id del contenitore top (g•PRO)
	classBox		→ classe del contenitore top (g•PRO)
	
	idField			→ id del contenitore intermedio (Material)
	classField		→ classe del contenitore top (Material)
	
	id				→ id
	caption			→ etichetta
	captionFirst	→ (boolean) etichetta prima dello switch (default = false)
	class			→ class
	checked			→ checked (se forzato tramite il parametro setChecked)
	dataTransform	→ dataTransform (es. MD5)
	dataBadge		→ dataBadge
	icon			→ icona
	icon_lib_fa		→ libreria fontawesome 
	mapping			→ mapping
	rel				→ rel
	required		→ (boolean) required (default = false)
	readOnly		→ (boolean) readOnly (default = false)
	rows			→ (integer) rows (default = 3)
	title			→ tooltip (mappato tramite l'attributo title del contenitore)
	value			→ value
	
	setChecked		→ (boolean) indica se attribuire forzosamente un valore all'oggetto o lasciare che venga recuperato dal mapping	
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="switchId" value="${empty param.switch_id ? f:lostId() : param.switch_id}" />

<div
	id		= "${param.switch_idBox}"
	class	= "gpro-mdc-text-field-box gpro-mdc-text-field-box--switch ${param.switch_classBox}"
	rel		= "${param.switch_rel}"
	title	= "${param.switch_title}">

	<c:if test="${param.switch_captionFirst == 'true' && (not empty param.switch_caption || not empty param.switch_icon)}">
		<label for="${switchId}" class="gpro-mdc-text-field-box--switch__label">
			<c:if test="${not empty param.switch_icon}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_lib_fa" value="${param.switch_icon_lib_fa}" />
					<jsp:param name="icon_icon" value="${param.switch_icon}" />
				</jsp:include>
			</c:if>
			<span>${param.switch_caption}</span>
		</label>
	</c:if>

	<div
		id					= "${param.switch_idField}"
		class				= "mdc-switch ${param.switch_classField}"
		data-mdc-auto-init	= "MDCSwitch">
		
		<div class="mdc-switch__track"></div>
		<div class="mdc-switch__thumb-underlay">
			<div class="mdc-switch__thumb"></div>
			
			<c:choose>
				<c:when test="${param.switch_setChecked == 'true' || not empty param.switch_checked}">
					<html:input
						checked		= "${param.switch_checked}"
						
						type		= "checkbox"
						
						id			= "${switchId}"
						mapping		= "${param.switch_mapping}"
						disabled	= "${param.switch_disabled}"
						value		= "${param.switch_value}"
						classname	= "mdc-switch__native-control ${param.switch_class}" />
				</c:when>
				
				<c:otherwise>
					<html:input
						type		= "checkbox"
						
						id			= "${switchId}"
						mapping		= "${param.switch_mapping}"
						disabled	= "${param.switch_disabled}"
						value		= "${param.switch_value}"
						classname	= "mdc-switch__native-control ${param.switch_class}" />
				</c:otherwise>
			</c:choose>
		</div>
	</div>
	
	<c:if test="${param.switch_captionFirst != 'true' && (not empty param.switch_caption || not empty param.switch_icon)}">
		<label for="${switchId}" class="gpro-mdc-text-field-box--switch__label">
			<c:if test="${not empty param.switch_icon}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_lib_fa" value="${param.switch_icon_lib_fa}" />
					<jsp:param name="icon_icon" value="${param.switch_icon}" />
				</jsp:include>
			</c:if>
			<span>${param.switch_caption}</span>
		</label>
	</c:if>
</div>