<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	textarea_
	
	
	
	PARAMETRI
	–––––––––
	idBox			→ id del contenitore top (g•PRO)
	classBox		→ classe del contenitore top (g•PRO)
	
	idField			→ id del contenitore intermedio (Material)
	classField		→ classe del contenitore top (Material)
	
	id				→ id
	caption			→ etichetta
	class			→ class
	dataTransform	→ dataTransform (es. MD5)
	dataBadge		→ dataBadge
	disabled		→ (boolean) disabled (default = false)
	mapping			→ mapping
	placeHoler		→ placeholder
	required		→ (boolean) required (default = false)
	readOnly		→ (boolean) readOnly (default = false)
	ripple			→ (boolean) ripple (default = true)
	rows			→ (integer) rows (default = 3)
	title			→ tooltip (mappato tramite l'attributo title del contenitore)
	value			→ valore (se forzato tramite il parametro setValue)
	
	setValue		→ (boolean) indica se attribuire forzosamente un valore all'oggetto o lasciare che venga recuperato dal mapping	
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="hasCaption" value="${not empty param.textarea_caption}" />
<c:set scope="page" var="hasRipple" value="${empty param.textarea_ripple || param.textarea_ripple == 'true' || param.textarea_ripple == 'true'}" />

<c:if test="${not empty param.textarea_dataTransform}">
	<c:set scope="page" var="inputExtraClass" value="data-transform__${dataTransform}" />
</c:if>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	id="${param.textarea_idBox}"
	class="gpro-mdc-text-field-box ${param.textarea_classBox}"
	title="${param.textarea_title}">
	
	<label
		id="${param.textarea_idField}"
		class="	mdc-text-field
				${' '}
				${hasCaption ? '' : ' mdc-text-field--no-label '}
				${' '}
				${hasRipple ? '' : ' mdc-text-field--no-ripple '}
				${' '}
				${param.textarea_classField}"
		data-mdc-auto-init="MDCTextField">
		
		<span class="mdc-text-field__ripple"></span>
  
		<c:choose>
			<c:when test="${param.textarea_setValue == 'true'}">
				<html:textarea
					value			= "${param.textarea_value}"
				
					id				= "${param.textarea_id}"
					mapping			= "${param.textarea_mapping}"
					required		= "${empty param.textarea_required ? false : param.textarea_required}"
					readonly		= "${empty param.textarea_readOnly ? false : param.textarea_readOnly}"
					disabled		= "${empty param.textarea_disabled ? false : param.textarea_disabled}"
					dataTransform	= "${param.textarea_dataTransform}"
					dataBadge		= "${param.textarea_dataBadge}"
					rows			= "${empty param.textarea_rows ? 3 : param.textarea_rows}"
					placeholder		= "${param.textarea_placeHolder}"
					classname		= "mdc-text-field__input ${param.textarea_class} ${inputExtraClass}" />
			</c:when>
			
			<c:otherwise>
				<html:textarea
					id				= "${param.textarea_id}"
					mapping			= "${param.textarea_mapping}"
					required		= "${empty param.textarea_required ? false : param.textarea_required}"
					readonly		= "${empty param.textarea_readOnly ? false : param.textarea_readOnly}"
					disabled		= "${empty param.textarea_disabled ? false : param.textarea_disabled}"
					dataTransform	= "${param.textarea_dataTransform}"
					dataBadge		= "${param.textarea_dataBadge}"
					rows			= "${empty param.textarea_rows ? 3 : param.textarea_rows}"
					placeholder		= "${param.textarea_placeHolder}"
					classname		= "mdc-text-field__input ${param.textarea_class} ${inputExtraClass}" />
			</c:otherwise>
		</c:choose>

		<c:if test="${hasCaption}"><span class="mdc-floating-label">${param.textarea_caption}</span></c:if>
		
		<span class="mdc-line-ripple"></span>
	</label>
</div>