<%@ include file="/_core/system/directives.jsp" %>

<%@page import="it.triware.taglib.Functions"%>

<%
	pageContext.setAttribute("LAYOUTS", Util.getFolders("app/_layouts"));
	pageContext.setAttribute("STYLES", Util.getFolders("app/_styles"));
	pageContext.setAttribute("LANGUAGES", Application.getLanguages().split(","));
%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

{
	"version"			: "<%= Application.getVersion() %>",
	"debug"				: "<%= Application.isDebug() %>",
	"debugLevel"		: "<%= Application.getDebugLevel() %>",
	"encoding"			: "<%= Application.getDataEncoding() %>",

	"refdate"			: "<%= Util.getSyncMillis() %>",

	"accept_language"	: "${header["accept-language"]}",

	"contextPath"		: "${APPLICATION.contextPath}",
	"supportEmail"		: "<%= Util.trim(Application.getSupportEmail()) %>",
	"appId"				: "<%= Util.getUniqueAppID() %>",
	"appName"			: "<%= Util.trim(Application.getName()) %>",
	"dlulAddress"		: "<%= Util.trim(Application.getDlUlAddress()) %>",
	
	"googleKey"			: "<%= Util.trim(Application.getGoogleKey()) %>",
	"social"			:
						{
							"google" 	: "<%= Util.trim(Application.getSocialLoginGoogleAppId()) %>",
							"facebook"	: "<%= Util.trim(Application.getSocialLoginFacebookAppId()) %>",
							"linkedin"	: "<%= Util.trim(Application.getSocialLoginLinkedinAppId()) %>"
						},
	"analytics"			:
						{
							"google" 	: "<%= Util.trim(Application.getAnalyticsGoogleAppId()) %>"
						},
	"s3"				:
						{
							"bucket"		: "<%= Util.trim(Application.getStorageS3Bucket()) %>",
							"connectionKey"	: "<%= Util.trim(Application.getS3ConnectionKey()) %>"
						},

	"layouts"			: "<c:forEach items="${LAYOUTS}" var="layout" varStatus="status">${layout}<c:if test="${!status.last}">,</c:if></c:forEach>",
	"styles"			: "<c:forEach items="${STYLES}" var="style" varStatus="status">${style}<c:if test="${!status.last}">,</c:if></c:forEach>",
	"languages"			: "<c:forEach items="${LANGUAGES}" var="language" varStatus="status">${language}<c:if test="${!status.last}">,</c:if></c:forEach>",
	"defaultLayout"		: "<%= Util.trim(Application.getDefaultLayout()) %>",
	"defaultStyle"		: "<%= Util.trim(Application.getDefaultStyle()) %>",
	"defaultLanguage"	: "<%= Util.trim(Application.getDefaultLanguage()) %>",
	
	"url"				:
						{
							<%-- questi url sono visibili, quindi li lascio più "neutri" --%>
							"goto"						: "goto",
							"download"					: "download",
							"print"						: "print",
							
							"push"						: "_gPRO_push",
							"layouts"					: "_gPRO_layouts",
							"login"						: "_gPRO_login",
							"interface"					: "_gPRO_interface",
							"public"					: "_gPRO_public",
							"translate"					: "_gPRO_translate",
							"profilo"					: "_gPRO_profilo", 
							"soggetto"					: "_gPRO_soggetto",
							"soggettoExtra"				: "_gPRO_soggettoExtra",
							"account"					: "_gPRO_account",
							"util"						: "_gPRO_util",
							"help"						: "_gPRO_help",
							"upload"					: "_gPRO_upload",
							"upload_progress"			: "_gPRO_uploadProgress",
							"upload_avatar"				: "_gPRO_uploadAvatar",
							"upload_soggettoAllegato"	: "_gPRO_uploadSoggettoAllegato",
							"upload_storage"			: "_gPRO_uploadStorage"
						},
	
	"license"			: "<%= Functions.formatForJSON(Util.trim(Util.getTextFileContent(Util.getRealPath("license.dat")))) %>",
	
	"_"					: ""
}