<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- header --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/step/search/toolbar.html.jsp" />

<div class="app-search-advanced-container mdc-theme--surface mdc-theme--on-surface mdc-elevation--z4">
	<h2 class="title">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="tune" />
		</jsp:include>
		<span><html:message key="Ricerca_avanzata" /></span>
	</h2>
	
	<jsp:include page="/_core/system/include/input.html.jsp">
		<jsp:param name="input_mapping" value="pojo.codice" />
		<jsp:param name="input_classBox" value="x1_2" />
		<jsp:param name="input_dataTransform" value="uppercase" />
		<jsp:param name="input_caption" value="${f:message(LOCALE, 'Codice')}" />
	</jsp:include>

	<jsp:include page="/_core/system/include/input.html.jsp">
		<jsp:param name="input_mapping" value="pojo.nome" />
		<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome')}" />
	</jsp:include>
</div>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- contenuto della ricerca --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="mdc-data-table app-search-table-container">
	<div class="mdc-data-table__table-container">
		<table class="mdc-data-table__table app-search-table gpro-data gpro-sortable">
			<thead sortfield="nome" sortorder="1">
				<tr class="mdc-data-table__header-row">
					<th name="codice" class="mdc-data-table__header-cell gpro-min-width"><html:message key="Codice" /></th>
					<th name="nome" class="mdc-data-table__header-cell gpro-min-width"><html:message key="Nome" /></th>
					<th name="descrizione" class="mdc-data-table__header-cell"><html:message key="Descrizione" /></th>
				</tr>
			</thead>
			
			<tbody class="mdc-data-table__content mdc-elevation--z1">
			</tbody>
	
			<tfoot>
				<tr>
					<td>
						<jsp:include page="/app/_common/pagination.html.jsp" />
					</td>
				</tr>
			</tfoot>
		</table>
	</div>
</div>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- messaggio in caso di ricerca a vuoto --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_class" value="app-search-empty-message" />
</jsp:include>