<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<input type="hidden" class="requirePageCSS" value="{COMMON}/directory/item/default.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/directory/item/default.js" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- scheda principale --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%-- param.directoryItem_sourceTitle - default true --%>
<%-- flag per chiedere l'utilizzo dei campi anagrafici nome, cognome e ragioneSociale per la composizione del titolo --%>
<c:if test="${empty param.directoryItem_sourceTitle || param.directoryItem_sourceTitle == 'true'}">
	<c:set scope="page" var="sourceClass" value="app-item-title-source" />
</c:if>

<div class="mdc-card">
	<%-- param.directoryItem_company impostato forzosamente true/false --%>
	<c:if test="${not empty param.directoryItem_company}">
		<html:input type="hidden" mapping="pojo.azienda" value="${param.directoryItem_company}" />
	</c:if>

	<%-- param.directoryItem_title - default null --%>
	<c:if test="${not empty param.directoryItem_title}">
		<div class="mdc-card__title">
			${param.directoryItem_title == 'true' ? f:message(LOCALE, 'Anagrafica') : param.directoryItem_title}
		</div>
	</c:if>
	
	<%-- riga per i flags --%>
	<c:if test="${empty param.directoryItem_company || not empty param.directoryItem_flags}">
		<div class="mdc-card__content checks-only">
			<%-- flag azienda non impostato e quindi da rendere visibile con switch --%>
			<c:if test="${empty param.directoryItem_company}">
				<jsp:include page="/_core/system/include/switch.html.jsp">
					<jsp:param name="switch_idBox" value="chkAzienda" />
					<jsp:param name="switch_mapping" value="pojo.azienda" />
					<jsp:param name="switch_caption" value="${f:message(LOCALE, 'Azienda')}" />
				</jsp:include>
			</c:if>
			
			<%-- eventuali flag aggiuntivi --%>
			${param.directoryItem_flags}
		</div>
	</c:if>
	
	<div class="mdc-card__content">
		<%-- ragione sociale (alternativo a "nome + cognome") --%>
		<div class="ragioneSociale-box ui-helper-hidden">
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_class" value="${sourceClass}" />
				<jsp:param name="input_classBox" value="x2" />
				<jsp:param name="input_mapping" value="pojo.ragioneSociale" />
				<jsp:param name="input_required" value="true" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Ragione_sociale')}" />
			</jsp:include>
		</div>

		<%-- nome + cognome (alternativo a "ragioneSociale") --%>				
		<div class="nomeCognome-box ui-helper-hidden">
			<%-- nome --%>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_class" value="${sourceClass}" />
				<jsp:param name="input_mapping" value="pojo.nome" />
				<jsp:param name="input_required" value="true" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome')}" />
			</jsp:include>

			<%-- cognome --%>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_class" value="${sourceClass}" />
				<jsp:param name="input_mapping" value="pojo.cognome" />
				<jsp:param name="input_required" value="true" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Cognome')}" />
			</jsp:include>

			<c:if test="${param.directoryItem_birth == 'true'}">
				<%-- luogo di nascita --%>
				<jsp:include page="/_core/system/include/input.html.jsp">
					<jsp:param name="input_mapping" value="pojo.luogoNascita" />
					<jsp:param name="input_caption" value="${f:message(LOCALE, 'Luogo_nascita')}" />
				</jsp:include>
				
				<%-- data di nascita --%>
				<jsp:include page="/_core/system/include/input.html.jsp">
					<jsp:param name="input_mapping" value="pojo.dataNascita" />
					<jsp:param name="input_customType" value="date" />
					<jsp:param name="input_caption" value="${f:message(LOCALE, 'Data_nascita')}" />
				</jsp:include>
			</c:if>
		</div>

		<%-- indirizzo --%>
		<jsp:include page="/_core/system/include/address.html.jsp" />
		
		<div>
			<%-- email --%>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_mapping" value="email" />
				<jsp:param name="input_maxLength" value="100" />
				<jsp:param name="input_customType" value="link|type=mail" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Email')}" />
			</jsp:include>

			<%-- sito web --%>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_mapping" value="web" />
				<jsp:param name="input_maxLength" value="100" />
				<jsp:param name="input_customType" value="link|type=www" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Sito_web')}" />
			</jsp:include>
		</div>			

		<%-- param.directoryItem_sdi - default true --%>
		<%-- flag per chiedere i campi necessari per la comunicazione con il Sistema di Interscambio (SDI) dell'Agenzia delle entrate --%>
		<c:if test="${empty param.directoryItem_sdi || param.directoryItem_sdi == 'true'}">
			<div>
				<%-- PEC --%>
				<jsp:include page="/_core/system/include/input.html.jsp">
					<jsp:param name="input_mapping" value="pec" />
					<jsp:param name="input_maxLength" value="100" />
					<jsp:param name="input_customType" value="link|type=mail" />
					<jsp:param name="input_caption" value="${f:message(LOCALE, 'PEC')}" />
				</jsp:include>

				<%-- codice destinatario --%>
				<jsp:include page="/_core/system/include/input.html.jsp">
					<jsp:param name="input_mapping" value="codiceDestinatario" />
					<jsp:param name="input_maxLength" value="7" />
					<jsp:param name="input_dataTransform" value="uppercase" />
					<jsp:param name="input_caption" value="${f:message(LOCALE, 'Codice_destinatario')}" />
				</jsp:include>
			</div>
		</c:if>

		<div>
			<%-- codice fiscale --%>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_mapping" value="pojo.codiceFiscale" />
				<jsp:param name="input_dataTransform" value="uppercase" />
				<jsp:param name="input_required" value="${not empty param.directoryItem_codiceFiscaleRequired && param.directoryItem_codiceFiscaleRequired == 'true'}" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Codice_fiscale')}" />
			</jsp:include>

			<%-- partita IVA --%>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_mapping" value="pojo.partitaIva" />
				<jsp:param name="input_dataTransform" value="uppercase" />
				<jsp:param name="input_required" value="${not empty param.directoryItem_partitaIvaRequired && param.directoryItem_partitaIvaRequired == 'true'}" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Partita_IVA')}" />
			</jsp:include>
		</div>
		
		${param.directoryItem_after}
	</div>	<%-- // .mdc-card__content --%>
</div>		<%-- // .mdc-card --%>



<div class="info-aggiuntive">

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- numeri di telefono --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%-- param.directoryItem_telephones - default true --%>
<%-- carica anche la sezione che gestisce i numeri di telefono --%>
<c:if test="${empty param.directoryItem_telephones || param.directoryItem_telephones == 'true'}">
	<div class="mdc-card">
		<div class="mdc-card__title gpro-display-flex-row-center">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="sidebar-button aggiungi-telefono no-margin" />
				<jsp:param name="button_rel" value="item" />
				<jsp:param name="button_icon" value="playlist_add" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Aggiungi_telefono')}" />
			</jsp:include>
			
			<span class="gpro-flex-grow"><html:message key="Telefoni" /></span>
		</div>

		<div class="mdc-card__content gpro-js-telephones-box telefoni-box ${empty BEAN.telefoni ? ' with-empty-message ' : ''}">
			<jsp:include page="/app/_common/step/subItems/telephones/default.html.jsp">
				<jsp:param name="telephones_embedded" value="true" />
			</jsp:include>
		</div>
	</div>
</c:if>


<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- email aggiuntive --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%-- param.directoryItem_emails - default false --%>
<%-- carica anche la sezione che gestisce le emails --%>
<c:if test="${not empty param.directoryItem_emails && param.directoryItem_emails == 'true'}">
	<div class="mdc-card">
		<div class="mdc-card__title gpro-display-flex-row-center">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="sidebar-button aggiungi-email no-margin" />
				<jsp:param name="button_rel" value="item" />
				<jsp:param name="button_icon" value="playlist_add" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Aggiungi_email')}" />
			</jsp:include>
			
			<span class="gpro-flex-grow"><html:message key="Email" /></span>
		</div>

		<div class="mdc-card__content gpro-js-emails-box emails-box ${empty BEAN.emails ? ' with-empty-message ' : ''}">
			<jsp:include page="/app/_common/step/subItems/emails/default.html.jsp">
				<jsp:param name="emails_embedded" value="true" />
			</jsp:include>
		</div>
	</div>
</c:if>

</div>