<%@ include file="/_core/system/directives.jsp" %>

<%@ page import="it.triware.i18n.Translator" %>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- header --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/step/search/toolbar.html.jsp" />

<div class="app-search-advanced-container mdc-theme--surface mdc-theme--on-surface mdc-elevation--z4">
	<h2 class="title">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="tune" />
		</jsp:include>
		<span><html:message key="Ricerca_avanzata" /></span>
	</h2>
	
	<jsp:include page="/_core/system/include/input.html.jsp">
		<jsp:param name="input_mapping" value="pojo.ragioneSociale" />
		<jsp:param name="input_caption" value="${f:message(LOCALE, 'Ragione_sociale')}" />
	</jsp:include>

	<c:set scope="page" var="options">
		<c:forEach items="${Translator.getNazioni()}" var="nazione">
			<c:set scope="page" var="nazioneNome" value="${f:displayCountry2(nazione.codice, LOCALE)}" />
			<c:if test="${not empty nazioneNome}">
				${nazione.id},rel=${nazione.codice}|${nazioneNome}||
			</c:if>
		</c:forEach>
	</c:set>
	<jsp:include page="/_core/system/include/select.html.jsp">
		<jsp:param name="select_mapping" value="indirizzo.idNazione" />
		<jsp:param name="select_firstEmpty" value="true" />
		<jsp:param name="select_caption" value="${f:message(LOCALE, 'Nazione')}" />
		<jsp:param name="select_options" value="${options}" />
	</jsp:include>

	<br />

	<jsp:include page="/_core/system/include/input.html.jsp">
		<jsp:param name="input_mapping" value="pojo.codiceFiscale" />
		<jsp:param name="input_caption" value="${f:message(LOCALE, 'Codice_fiscale')}" />
	</jsp:include>

	<jsp:include page="/_core/system/include/input.html.jsp">
		<jsp:param name="input_mapping" value="pojo.partitaIva" />
		<jsp:param name="input_caption" value="${f:message(LOCALE, 'Partita_iva')}" />
	</jsp:include>
</div>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- contenuto della ricerca --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="mdc-data-table app-search-table-container">
	<div class="mdc-data-table__table-container">
		<table class="mdc-data-table__table app-search-table gpro-data gpro-sortable">
			<thead>
				<tr class="mdc-data-table__header-row">
					<th name="nominativo" sortfield="cognome, nome, ragioneSociale" class="mdc-data-table__header-cell"><html:message key="Nominativo" /></th>
					<th name="indirizzo" class="mdc-data-table__header-cell gpro-not-sortable"><html:message key="Indirizzo" /></th>
					<th name="codiceFiscale" class="mdc-data-table__header-cell"><html:message key="Codice_fiscale" /></th>
					<th name="partitaIva" class="mdc-data-table__header-cell"><html:message key="Partita_iva" /></th>
				</tr>
			</thead>
			
			<tbody class="mdc-data-table__content mdc-elevation--z1">
			</tbody>
	
			<tfoot>
				<tr>
					<td>
						<jsp:include page="/app/_common/pagination.html.jsp" />
					</td>
				</tr>
			</tfoot>
		</table>
	</div>
</div>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- messaggio in caso di ricerca a vuoto --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_class" value="app-search-empty-message" />
</jsp:include>