<%@ include file="/_core/system/directives.jsp" %>



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%
	pageContext.setAttribute("LANGUAGES", Application.getLanguages().split(","));
	pageContext.setAttribute("LAYOUTS", Util.getFolders("app/_layouts"));
	pageContext.setAttribute("LAYOUT", Transaction.getLayout(request));
	pageContext.setAttribute("SHOW_LAYOUTS_MENU", Boolean.valueOf(it.triware.util.AppSettings.getShowLayoutsMenu()));
	pageContext.setAttribute("LANGUAGE", Transaction.getLanguage(request));
%>

<%-- la variabile CAN_CHANGE_LAYOUT (default true) viene impostata applicativamente per condizionare la visualizzazione dei layout --%>
<c:if test="${empty CAN_CHANGE_LAYOUT}">
	<c:set scope="page" var="CAN_CHANGE_LAYOUT" value="true" />
</c:if>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<div class="mdc-menu mdc-menu-surface mdc-menu--with-icons">
	<ul class="mdc-list" role="menu">
		<li class="mdc-list-item app-starter" role="menuitem" rel="_gPRO_profilo">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_class" value="mdc-list-item__graphic" />
				<jsp:param name="icon_icon" value="account_circle" />
			</jsp:include>
			<span class="mdc-list-item__text"><html:message key="Modifica_profilo" /></span>
		</li>

		<%-- selezione della lingua (se multi lingua) --%>
		<c:if test="${not empty LANGUAGES && fn:length(LANGUAGES) > 1}">
			<li class="mdc-list-divider" role="separator"></li>

			<li>
				<ul class="mdc-menu__selection-group">
					<c:forEach items="${LANGUAGES}" var="language">
						<li class="mdc-list-item ${language == LANGUAGE ? ' mdc-menu-item--selected ' : ' app-language-selector ' }" role="menuitem" rel="${language}">
							<jsp:include page="/_core/system/include/icon.html.jsp">
								<jsp:param name="icon_class" value="mdc-list-item__graphic" />
								<jsp:param name="icon_icon" value="language" />
							</jsp:include>
							<span class="mdc-list-item__text">${f:displayLanguage2(language, LOCALE)}</span>
						</li>
					</c:forEach>
				</ul>
			</li>
		</c:if>
		
		<%-- selezione del layout --%>
		<c:if test="${fn:length(LAYOUTS) > 1 && (SHOW_LAYOUTS_MENU && CAN_CHANGE_LAYOUT)}">
			<li class="mdc-list-divider" role="separator"></li>

			<li>
				<ul class="mdc-menu__selection-group">
					<c:forEach items="${LAYOUTS}" var="layout">
						<li class="mdc-list-item ${layout == LAYOUT ? ' mdc-menu-item--selected ' : ' app-layout-selector ' }" role="menuitem" rel="${layout}">
							<jsp:include page="/_core/system/include/icon.html.jsp">
								<jsp:param name="icon_class" value="mdc-list-item__graphic" />
								<jsp:param name="icon_icon" value="wysiwyg" />
							</jsp:include>
							<span class="mdc-list-item__text"><html:message key="layout-${layout}" /></span>
						</li>
					</c:forEach>
				</ul>
			</li>
		</c:if>
		
		<li class="mdc-list-divider" role="separator"></li>
		
		<li class="mdc-list-item" role="menuitem" action="logout">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_class" value="mdc-list-item__graphic" />
				<jsp:param name="icon_icon" value="logout" />
			</jsp:include>
			<span class="mdc-list-item__text"><html:message key="Logout" /></span>
		</li>
	</ul>
</div>