<%@ include file="/_core/system/directives.jsp" %>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%-- param.item_checkEditing - default true --%>
<c:if test="${empty param.item_checkEditing || param.item_checkEditing == 'true'}">
	<c:set scope="page" var="ITEM_CHECK_EDITING" value="true" />
</c:if>

<%-- se c'è la gestione dei pulsanti ANNULLA/SALVA e stiamo aprendo una nuova scheda, allora si attiva subito la modalità di salvataggio --%>
<c:if test="${(empty param.toolbar_cancelSave || param.toolbar_cancelSave == 'true') && (ITEM_CHECK_EDITING == 'true' && !BEAN.pojo.stored)}">
	<c:set scope="page" var="EDITING_CLASS" value="app-breadcrumb--editing" />
</c:if>

<%-- param.toolbar_breadCrumb - default true --%>
<%-- indica che vogliamo la navigazione breadcrumb tra le schede che verrano apperte da questa pagina --%>
<c:if test="${empty param.toolbar_breadCrumb || param.toolbar_breadCrumb == 'true'}">
	<c:set scope="page" var="BREADCRUMB_BASE_CLASS" value="app-breadcrumb" />
</c:if>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%-- param.toolbar_windowSelector - default true --%>
<%-- indica che vogliamo il menu di scelta rapida tra le applicazioni aperte --%>
<c:if test="${empty param.toolbar_windowSelector || param.toolbar_windowSelector == 'true'}">
	<div class="mdc-menu-surface--anchor">
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_class" value="app-window__selector gpro-mdc-menu-surface--anchor-trigger" />
			<jsp:param name="button_icon" value="menu_open" />
			<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Applicazioni_aperte')}" />
		</jsp:include>
		
		<div class="mdc-menu mdc-menu-surface app-window__menu">
			<ul class="mdc-list" role="menu"></ul>
		</div>
	</div>
</c:if>

<%-- param.toolbar_label - default true --%>
<%-- indica che vogliamo l'etichetta --%>
<c:if test="${empty param.toolbar_label || param.toolbar_label == 'true'}">
	<span	class=	"app-item-title-label
					${' '}
					${BREADCRUMB_BASE_CLASS}
					${' '}
					${param.toolbar_breadCrumbClass}
					${' '}
					${EDITING_CLASS}"
			title=	"${param.toolbar_title}">
		${param.toolbar_title}
	</span>
</c:if>

<%-- param.toolbar_buttonClose - default true --%>
<%-- indica che vogliamo il pulsante per la chiusura pagina che stiamo aprendo --%>
<c:if test="${empty param.toolbar_buttonClose || param.toolbar_buttonClose == 'true'}">
	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="app-section-back" />
		<jsp:param name="button_icon" value="close" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Chiudi')}" />
	</jsp:include>
</c:if>