<%@ include file="/_core/system/directives.jsp" %>

<jsp:include page="preData.html.jsp" />
<jsp:include page="selectedTab.html.jsp" />

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<input type="hidden" class="requirePageCSS" value="{COMMON}/step/item/default.css" />

<%-- param.item_js - default true --%>
<%-- carica anche il javascript predefinito --%>
<c:if test="${empty param.item_js || param.item_js == 'true'}">
	<input type="hidden" class="requirePageJS" value="{COMMON}/step/item/default.js" />
</c:if>

<%-- param.item_sidebar - default false --%>
<c:if test="${param.item_sidebar == 'true'}">
	<input type="hidden" class="requirePageJS" value="{COMMON}/step/item/sidebar.js" />
</c:if>

<%-- param.item_checkEditing - default true --%>
<c:if test="${empty param.item_checkEditing || param.item_checkEditing == 'true'}">
	<c:set scope="page" var="ITEM_CHECK_EDITING" value="true" />
</c:if>



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<div class="mdc-top-app-bar__row mdc-theme--surface mdc-theme--on-surface ${ITEM_CHECK_EDITING == true && !BEAN.pojo.stored ? ' editing new-record ' : ''}">
	<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-start">
		<jsp:include page="/app/_common/navigator.html.jsp" />
	</section>
	
	<section class="gpro-flex-grow"></section>
	
	<%-- param.toolbar - default true --%>
	<%-- mostra la toolbar principale --%>
	<c:if test="${empty param.toolbar || param.toolbar == 'true'}">
		<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end app-window__toolbar">
			<%-- param.toolbar_buttonPrint - default false --%>
			<%-- mostra il pulsante per la stampa della scheda --%>
			<c:if test="${param.toolbar_buttonPrint == 'true'}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_icon" value="print" />
					<jsp:param name="button_action"	value="print" />
					<jsp:param name="button_class" value="print-item" />
					<jsp:param name="button_tag" value="${URL}" />
					<jsp:param name="button_rel" value="${BEAN.pojo.id}" />
					<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Stampa')}" />
				</jsp:include>
			</c:if>
	
			<%-- param.toolbar_buttonDelete - default true --%>
			<%-- mostra il pulsante per l'eliminazione della scheda --%>
			<c:if test="${empty param.toolbar_buttonDelete || param.toolbar_buttonDelete == 'true'}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_class" value="pojo-stored" />
					<jsp:param name="button_icon" value="delete" />
					<jsp:param name="button_step" value="delete" />
					<jsp:param name="button_action"	value="delete" />
					<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Elimina')}" />
				</jsp:include>
			</c:if>
		
			<%-- param.toolbar_buttonNew - default false --%>
			<%-- mostra il pulsante per creare una nuova scheda --%>
			<c:if test="${param.toolbar_buttonNew == 'true'}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_action"		value="new" />
					<jsp:param name="button_icon"	 	value="add_box" />
					<jsp:param name="button_step"		value="${empty param.toolbar_stepNewItem ? 'newItem' : param.toolbar_stepNewItem}" />
					<jsp:param name="button_tooltip"	value="${f:message(LOCALE, 'Nuovo')}" />
				</jsp:include>
			</c:if>
		</section>
	</c:if>
	
	<%-- param.toolbar_cancelSave - default true --%>
	<%-- motra i pulsanti ANNULLA/SALVA automatici per il salvataggio delle modifiche fatte o il ripristino alla situazione precedente --%>
	<c:if test="${empty param.toolbar_cancelSave || param.toolbar_cancelSave == 'true'}">
		<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end app-window__cancelsave">
			<c:if test="${BEAN.pojo.stored || not empty param.toolbar_cancelSave_full}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_action"	value="cancel" />
					<jsp:param name="button_text"	value="${f:message(LOCALE, 'Annulla')}" />
				</jsp:include>
			</c:if>
			
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_raised"					value="true" />
				<jsp:param name="button_checkRequiredFields"	value="true" />
				<jsp:param name="button_validation"				value="true" />
				<jsp:param name="button_action"					value="save" />
				<jsp:param name="button_step"					value="${empty param.toolbar_stepSave ? 'save' : param.toolbar_stepSave}" />
				<jsp:param name="button_text"					value="${f:message(LOCALE, 'Salva')}" />
			</jsp:include>
		</section>
	</c:if>
</div>