<%@ include file="/_core/system/directives.jsp" %>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<input type="hidden" class="requirePageCSS" value="{COMMON}/step/search/default.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/step/search/default.js" />

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<div class="mdc-top-app-bar__row mdc-theme--surface mdc-theme--on-surface">
	<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-start">
		<jsp:include page="/app/_common/navigator.html.jsp">
			<jsp:param name="toolbar_title" value="${not empty param.toolbar_title ? param.toolbar_title : BEAN.pojoNamePlural}" />
			<jsp:param name="toolbar_cancelSave" value="false" />
		</jsp:include>
	</section>
	
	<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end app-window__toolbar gpro-flex-grow">
		<%-- param.toolbar_pattern - default true --%>
		<%-- mostra il campo per inserire il pattern per la ricerca generica --%>
		<c:if test="${empty param.toolbar_pattern || param.toolbar_pattern == 'true'}">
			<jsp:include page="/app/_common/searchPattern.html.jsp" />
		</c:if>

		<%-- punto dopo il quale verranno aggiunti i pulsanti della toolbar secondaria --%>
		<a class="placeholder-secondary-toolbar"></a>

		<%-- param.toolbar_advancedSearch - default true --%>
		<%-- mostra il pulsante per aprire il pannello di ricerca avanzato --%>
		<c:if test="${empty param.toolbar_advancedSearch || param.toolbar_advancedSearch == 'true'}">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="app-search-advanced-button" />
				<jsp:param name="button_icon" value="tune" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Ricerca_avanzata')}" />
			</jsp:include>
		</c:if>
		
		<%-- param.toolbar_buttonPrint - default true --%>
		<%-- mostra il pulsante per la stampa --%>
		<c:if test="${empty param.toolbar_buttonPrint || param.toolbar_buttonPrint == 'true'}">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_icon" value="print" />
				<jsp:param name="button_action" value="print" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Stampa')}" />
			</jsp:include>
		</c:if>
		
		<%-- param.toolbar_buttonExport - default true --%>
		<%-- mostra il pulsante per l'esportazione dei risultati in Excel --%>
		<c:if test="${empty param.toolbar_buttonExport || param.toolbar_buttonExport == 'true'}">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_icon" value="file_download" />
				<jsp:param name="button_action" value="export" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Esporta_in_excel')}" />
			</jsp:include>
		</c:if>
		
		<%-- param.toolbar_buttonNew - default true --%>
		<%-- mostra il pulsante per creare una nuova scheda --%>
		<c:if test="${empty param.toolbar_buttonNew || param.toolbar_buttonNew == 'true'}">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_icon"	 	value="add_box" />
				<jsp:param name="button_action" 	value="new" />
				<jsp:param name="button_tooltip"	value="${f:message(LOCALE, 'Nuovo')}" />
			</jsp:include>
		</c:if>
	</section>
</div>