<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	addresses_
	
	
	
	PARAMETRI
	–––––––––
	initialClass	→ (default = 'indirizzi-box') classe da assegnare al contenitore
	buttonClass		→ (default = 'aggiungi-indirizzo') classe del pulsante per l'aggiunta di un nuovo item
	listName		→ (default = 'indirizzi') nome dell'attributo del BEAN che contiene la lista dei pojo da rappresentare tramite item.html.jsp
	stepName		→ (default = 'indirizzo') nome dello step da invocare per l'aggiunta di un nuovo item
	embedded		→ (default = false) indica che il contenitore è contenuto nella pagina caricata da loadServletPage
	
	
	
	NOTE
	––––
	Questa pagina potrebbe essere richiamata da un'altra caricata via loadServletPage. In questo caso l'input.initialClass si applicherebbe al target principale
	e non a questo specifico contenitore. In questo caso non bisogna inserire un input.initialClass ma sarà onere della pagina chiamante definire un contenitore
	con le classi necessarie.
	
	La classe "gpro-js-addresses-box" è un marcatore per l'intercettazione via javascrit (prefisso "gpro-js") e non ha funzioni di decorazione CSS.
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- CSS & JS --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<input type="hidden" class="requirePageCSS" value="{COMMON}/step/subItems/addresses/default.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/step/subItems/addresses/default.js" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- personalizzazione del target --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="initialClass" value="${not empty param.addresses_initialClass ? param.addresses_initialClass : 'indirizzi-box'}" />
<c:set scope="page" var="buttonClass" value="${not empty param.addresses_buttonClass ? param.addresses_buttonClass : 'aggiungi-indirizzo'}" />
<c:set scope="page" var="listName" value="${not empty param.addresses_listName ? param.addresses_listName : 'indirizzi'}" />
<c:set scope="page" var="stepName" value="${not empty param.addresses_stepName ? param.addresses_stepName : 'indirizzo'}" />

<%-- Parametri ricevuti dalla JSP chiamante e che quindi non sono codificati --%>
<input type="hidden" id="initialClass" value="${initialClass}" />
<input type="hidden" id="buttonClass" value="${buttonClass}" />
<input type="hidden" id="listName" value="${listName}" />
<input type="hidden" id="stepName" value="${stepName}" />

<c:if test="${empty param.addresses_embedded || param.addresses_embedded == 'false' || f:applicationDecode(param.addresses_embedded) == 'false'}">
	<input
		type="hidden"
		class="initialClass"
		value="	gpro-js-addresses-box
				${' '}
				${initialClass}
				${' '}
				${empty BEAN[listName] ? 'with-empty-message' : ''}" />
</c:if>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- empty message --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_hidden" value="${not empty BEAN[listName]}" />
	<jsp:param name="emptyMessage_text" value="nessun_indirizzo_inserito" />
</jsp:include>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- items --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:forEach items="${BEAN[listName]}" varStatus="status">
	<jsp:include page="item.html.jsp" >
		<jsp:param name="index" value="${f:applicationEncode(status.index)}" />
		<jsp:param name="listName" value="${f:applicationEncode(listName)}" />
	</jsp:include>
</c:forEach>
