<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="index" value="${f:applicationDecode(param.index)}" />
<c:set scope="page" var="listName" value="${f:applicationDecode(param.listName)}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="mdc-card row-container item indirizzo">
	<html:input type="hidden" mapping="${listName}@${index}.id" />
	<html:input type="hidden" mapping="${listName}@${index}.idIndirizzo" />
	<html:input type="hidden" mapping="${listName}@${index}.indirizzoEdit.id" />

	<div class="mdc-card__content title">
		<%-- etichetta --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-flex-grow" />
			<jsp:param name="input_ripple" value="false" />
			<jsp:param name="input_mapping" value="${listName}@${index}.etichetta" />
			<jsp:param name="input_placeHolder" value="${f:message(LOCALE, 'Etichetta')}" />
		</jsp:include>

		<%-- menu --%>
		<div class="mdc-menu-surface--anchor menu-ops">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
				<jsp:param name="button_icon" value="more_vert" />
			</jsp:include>
			
			<div class="mdc-menu mdc-menu-surface">
				<ul class="mdc-list" role="menu">
					<li class="mdc-list-item row-container-remove" role="menuitem">
						<span class="mdc-list-item__text"><html:message key="Elimina" /></span>
					</li>
				</ul>
			</div>
		</div>
	</div>

	<%-- indirizzo --%>
	<jsp:include page="/_core/system/include/address.html.jsp">
		<jsp:param name="address_class" value="mdc-card__content" />
		<jsp:param name="address_mapping" value="${listName}@${index}.indirizzoEdit" />
		<jsp:param name="address_required" value="true" />
	</jsp:include>

	<%-- telefono --%>
	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-full-width" />
			<jsp:param name="input_mapping" value="${listName}@${index}.telefono" />
			<jsp:param name="input_customType" value="link|type=call" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Telefono')}" />
		</jsp:include>
	</div>	

	<%-- email --%>
	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-full-width" />
			<jsp:param name="input_mapping" value="${listName}@${index}.email" />
			<jsp:param name="input_customType" value="link|type=email" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Email')}" />
		</jsp:include>
	</div>	

	<%-- note --%>
	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/textarea.html.jsp">
			<jsp:param name="textarea_classBox" value="gpro-full-width" />
			<jsp:param name="textarea_rows" value="3" />
			<jsp:param name="textarea_mapping" value="${listName}@${index}.note" />
			<jsp:param name="textarea_placeHolder" value="${f:message(LOCALE, 'Note')}" />
		</jsp:include>
	</div>	
</div>