<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	attachments_
	
	
	
	PARAMETRI
	–––––––––
	initialClass	→ (default = 'allegati-box') classe da assegnare al contenitore
	buttonClass		→ (default = 'aggiungi-allegato') classe del pulsante per l'aggiunta di un nuovo item
	listName		→ (default = 'allegati') nome dell'attributo del BEAN che contiene la lista dei pojo da rappresentare tramite item.html.jsp
	stepName		→ (default = 'allegato') nome dello step da invocare per l'aggiunta di un nuovo item
	embedded		→ (default = false) indica che il contenitore è contenuto nella pagina caricata da loadServletPage
	readOnly		→ (default = false) indica che non si può modificare il contenuto
	
	
	
	NOTE
	––––
	Questa pagina potrebbe essere richiamata da un'altra caricata via loadServletPage. In questo caso l'input.initialClass si applicherebbe al target principale
	e non a questo specifico contenitore. In questo caso non bisogna inserire un input.initialClass ma sarà onere della pagina chiamante definire un contenitore
	con le classi necessarie.
	
	La classe "gpro-js-attachments-box" è un marcatore per l'intercettazione via javascrit (prefisso "gpro-js") e non ha funzioni di decorazione CSS.
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- CSS & JS --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<input type="hidden" class="requirePageCSS" value="{COMMON}/step/subItems/attachments/default.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/step/subItems/attachments/default.js" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- personalizzazione del target --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="initialClass" value="${not empty param.attachments_initialClass ? param.attachments_initialClass : 'allegati-box'}" />
<c:set scope="page" var="buttonClass" value="${not empty param.attachments_buttonClass ? param.attachments_buttonClass : 'aggiungi-allegato'}" />
<c:set scope="page" var="listName" value="${not empty param.attachments_listName ? param.attachments_listName : 'allegati'}" />
<c:set scope="page" var="stepName" value="${not empty param.attachments_stepName ? param.attachments_stepName : 'allegato'}" />
<c:set scope="page" var="readOnly" value="${not empty param.attachments_readOnly ? param.attachments_readOnly : false}" />

<%-- Parametri ricevuti dalla JSP chiamante e che quindi non sono codificati --%>
<input type="hidden" id="initialClass" value="${initialClass}" />
<input type="hidden" id="buttonClass" value="${buttonClass}" />
<input type="hidden" id="listName" value="${listName}" />
<input type="hidden" id="stepName" value="${stepName}" />

<c:if test="${empty param.attachments_embedded || param.attachments_embedded == 'false' || f:applicationDecode(param.attachments_embedded) == 'false'}">
	<input
		type="hidden"
		class="initialClass"
		value="	gpro-js-attachments-box
				${' '}
				${initialClass}
				${' '}
				${empty BEAN[listName] ? 'with-empty-message' : ''}" />
</c:if>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- empty message --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_hidden" value="${not empty BEAN[listName]}" />
	<jsp:param name="emptyMessage_text" value="nessun_allegato_inserito" />
</jsp:include>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- items --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:forEach items="${BEAN[listName]}" varStatus="status">
	<jsp:include page="item.html.jsp" >
		<jsp:param name="index" value="${f:applicationEncode(status.index)}" />
		<jsp:param name="listName" value="${f:applicationEncode(listName)}" />
		<jsp:param name="readOnly" value="${f:applicationEncode(readOnly)}" />
	</jsp:include>
</c:forEach>
