<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="index" value="${f:applicationDecode(param.index)}" />
<c:set scope="page" var="listName" value="${f:applicationDecode(param.listName)}" />
<c:set scope="page" var="readOnly" value="${f:applicationDecode(param.readOnly)}" />

<c:set scope="page" var="allegato" value="${BEAN[listName].get(index)}" />
<c:set scope="page" var="allegatoEdit" value="${allegato.allegatoEdit}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="mdc-card row-container item allegato">
	<html:input type="hidden" mapping="${listName}@${index}.id" />
	<html:input type="hidden" mapping="${listName}@${index}.idAllegato" />
	<html:input type="hidden" mapping="${listName}@${index}.allegatoEdit.id" />

	<div class="mdc-card__content title">
		<%-- etichetta --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-flex-grow" />
			<jsp:param name="input_ripple" value="false" />
			<jsp:param name="input_readOnly" value="${readOnly}" />
			<jsp:param name="input_mapping" value="${listName}@${index}.allegatoEdit.etichetta" />
			<jsp:param name="input_placeHolder" value="${f:message(LOCALE, 'Etichetta')}" />
		</jsp:include>

		<c:if test="${readOnly != true}">
			<%-- menu --%>
			<div class="mdc-menu-surface--anchor menu-ops">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
					<jsp:param name="button_icon" value="more_vert" />
				</jsp:include>
				
				<div class="mdc-menu mdc-menu-surface">
					<ul class="mdc-list" role="menu">
						<li class="mdc-list-item row-container-remove" role="menuitem">
							<span class="mdc-list-item__text"><html:message key="Elimina" /></span>
						</li>
					</ul>
				</div>
			</div>
		</c:if>
	</div>

	<%-- icona --%>
	<div class="mdc-card__content allegato-icona ${allegatoEdit.isImage() ? ' img ' : ''}" data-id="${allegatoEdit.id}">
		<c:choose>
			<c:when test="${allegatoEdit.isImage()}">
				<html:img
					mask	= "true"
					alt		= "${allegatoEdit.nome}"
					src		= "${APPLICATION.contextPath}/_gPRO_download?step=${f:applicationEncode('storageFile')}&id=${f:applicationEncode(allegatoEdit.id)}"
				/>
			</c:when>
			<c:otherwise>
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_icon" value="insert_drive_file" />
				</jsp:include>
			</c:otherwise>
		</c:choose>
	</div>
	
	<%-- dettagli --%>
	<div class="mdc-card__content info">
		<c:set scope="page" var="size" value="${allegatoEdit.dimensione > 1024 * 1024 ? 1024 * 1024 : 1024}" />
		<c:set scope="page" var="um" value="${allegatoEdit.dimensione > 1024 * 1024 ? 'MB' : 'KB'}" />

		<div>
			<span class="allegato-label"><html:message key="nome" /></span>
			<span class="allegato-value">${allegatoEdit.nome}</span>
		</div>

		<div>
			<span class="allegato-label"><html:message key="dimensione" /></span>
			<span class="allegato-value">${f:formatNumber(LOCALE, allegatoEdit.dimensione / size, 2, true)}<html:separator />${um}</span>
		</div>

		<div>
			<span class="allegato-label"><html:message key="data" /></span>
			<span class="allegato-value">${f:formatDateTime(TIMEZONE, LOCALE, allegatoEdit.data, 2, 2)}</span>
		</div>
	</div>

	<%-- note --%>
	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/textarea.html.jsp">
			<jsp:param name="textarea_classBox" value="gpro-full-width" />
			<jsp:param name="textarea_ripple" value="false" />
			<jsp:param name="textarea_readOnly" value="${readOnly}" />
			<jsp:param name="textarea_mapping" value="${listName}@${index}.allegatoEdit.note" />
			<jsp:param name="textarea_placeHolder" value="${f:message(LOCALE, 'note')}" />
		</jsp:include>
	</div>
</div>