<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	categories_
	
	
	
	PARAMETRI
	–––––––––
	initialClass	→ (default = 'categorie-box') classe da assegnare al contenitore
	buttonClass		→ (default = 'aggiungi-categoria') classe del pulsante per l'aggiunta di un nuovo item
	listName		→ (default = 'categorie') nome dell'attributo del BEAN che contiene la lista dei pojo da rappresentare tramite item.html.jsp
	pojoName		→ (default = 'categoria') nome del pojo contenutto nella lista corrispondente a listName
	fieldName		→ (default = 'idCategoria') nome del campo di lookup alla categoria
	stepName		→ (default = 'categoria') nome dello step da invocare per l'aggiunta di un nuovo item
	lookupUrl		→ (default = 'categorie') url per la lookup di ricerca delle categorie
	embedded		→ (default = false) indica che il contenitore è contenuto nella pagina caricata da loadServletPage
	
	
	
	NOTE
	––––
	Questa pagina potrebbe essere richiamata da un'altra caricata via loadServletPage. In questo caso l'input.initialClass si applicherebbe al target principale
	e non a questo specifico contenitore. In questo caso non bisogna inserire un input.initialClass ma sarà onere della pagina chiamante definire un contenitore
	con le classi necessarie.
	
	La classe "gpro-js-categories-box" è un marcatore per l'intercettazione via javascrit (prefisso "gpro-js") e non ha funzioni di decorazione CSS.
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- CSS & JS --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<input type="hidden" class="requirePageJS" value="{COMMON}/step/subItems/categories/default.js" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- personalizzazione del target --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="initialClass" value="${not empty param.categories_initialClass ? param.categories_initialClass : 'categorie-box'}" />
<c:set scope="page" var="buttonClass" value="${not empty param.categories_buttonClass ? param.categories_buttonClass : 'aggiungi-categoria'}" />
<c:set scope="page" var="listName" value="${not empty param.categories_listName ? param.categories_listName : 'categorie'}" />
<c:set scope="page" var="pojoName" value="${not empty param.categories_pojoName ? param.categories_pojoName : 'categoria'}" />
<c:set scope="page" var="fieldName" value="${not empty param.categories_fieldName ? param.categories_fieldName : 'idCategoria'}" />
<c:set scope="page" var="stepName" value="${not empty param.categories_stepName ? param.categories_stepName : 'categoria'}" />
<c:set scope="page" var="lookupUrl" value="${not empty param.categories_lookupUrl ? param.categories_lookupUrl : 'categorie'}" />

<%-- Parametri ricevuti dalla JSP chiamante e che quindi non sono codificati --%>
<input type="hidden" id="initialClass" value="${initialClass}" />
<input type="hidden" id="buttonClass" value="${buttonClass}" />
<input type="hidden" id="listName" value="${listName}" />
<input type="hidden" id="pojoName" value="${pojoName}" />
<input type="hidden" id="fieldName" value="${fieldName}" />
<input type="hidden" id="stepName" value="${stepName}" />
<input type="hidden" id="lookupUrl" value="${lookupUrl}" />

<c:if test="${empty param.categories_embedded || param.categories_embedded == 'false' || f:applicationDecode(param.categories_embedded) == 'false'}">
	<input
		type="hidden"
		class="initialClass"
		value="	gpro-js-categories-box
				${' '}
				${initialClass}
				${' '}
				${empty BEAN[listName] ? 'with-empty-message' : ''}" />
</c:if>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- empty message --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_hidden" value="${not empty BEAN[listName]}" />
	<jsp:param name="emptyMessage_text" value="nessuna_categoria_inserita" />
</jsp:include>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- items --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:forEach items="${BEAN[listName]}" varStatus="status">
	<jsp:include page="item.html.jsp" >
		<jsp:param name="index" value="${f:applicationEncode(status.index)}" />
		<jsp:param name="listName" value="${f:applicationEncode(listName)}" />
		<jsp:param name="pojoName" value="${f:applicationEncode(pojoName)}" />
		<jsp:param name="fieldName" value="${f:applicationEncode(fieldName)}" />
	</jsp:include>
</c:forEach>
