<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	contacts_
	
	
	
	PARAMETRI
	–––––––––
	initialClass	→ (default = 'contatti-box') classe da assegnare al contenitore
	buttonClass		→ (default = 'aggiungi-contatto') classe del pulsante per l'aggiunta di un nuovo item
	listName		→ (default = 'contatti') nome dell'attributo del BEAN che contiene la lista dei pojo da rappresentare tramite item.html.jsp
	stepName		→ (default = 'contatto') nome dello step da invocare per l'aggiunta di un nuovo item
	embedded		→ (default = false) indica che il contenitore è contenuto nella pagina caricata da loadServletPage
	
	
	
	NOTE
	––––
	Questa pagina potrebbe essere richiamata da un'altra caricata via loadServletPage. In questo caso l'input.initialClass si applicherebbe al target principale
	e non a questo specifico contenitore. In questo caso non bisogna inserire un input.initialClass ma sarà onere della pagina chiamante definire un contenitore
	con le classi necessarie.
	
	La classe "gpro-js-contatti-box" è un marcatore per l'intercettazione via javascrit (prefisso "gpro-js") e non ha funzioni di decorazione CSS.
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- CSS & JS --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<input type="hidden" class="requirePageCSS" value="{COMMON}/step/subItems/contacts/default.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/step/subItems/contacts/default.js" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- personalizzazione del target --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="initialClass" value="${not empty param.contacts_initialClass ? param.contacts_initialClass : 'contatti-box'}" />
<c:set scope="page" var="buttonClass" value="${not empty param.contacts_buttonClass ? param.contacts_buttonClass : 'aggiungi-contatto'}" />
<c:set scope="page" var="listName" value="${not empty param.contacts_listName ? param.contacts_listName : 'contatti'}" />
<c:set scope="page" var="stepName" value="${not empty param.contacts_stepName ? param.contacts_stepName : 'contatto'}" />

<%-- Parametri ricevuti dalla JSP chiamante e che quindi non sono codificati --%>
<input type="hidden" id="initialClass" value="${initialClass}" />
<input type="hidden" id="buttonClass" value="${buttonClass}" />
<input type="hidden" id="listName" value="${listName}" />
<input type="hidden" id="stepName" value="${stepName}" />

<c:if test="${empty param.contacts_embedded || param.contacts_embedded == 'false' || f:applicationDecode(param.contacts_embedded) == 'false'}">
	<input
		type="hidden"
		class="initialClass"
		value="	gpro-js-contatti-box
				${' '}
				${initialClass}
				${' '}
				${empty BEAN[listName] ? 'with-empty-message' : ''}" />
</c:if>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- empty message --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_hidden" value="${not empty BEAN[listName]}" />
	<jsp:param name="emptyMessage_text" value="nessun_contatto_inserito" />
</jsp:include>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- items --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:forEach items="${BEAN[listName]}" varStatus="status">
	<jsp:include page="item.html.jsp" >
		<jsp:param name="index" value="${f:applicationEncode(status.index)}" />
		<jsp:param name="listName" value="${f:applicationEncode(listName)}" />
	</jsp:include>
</c:forEach>
