<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="index" value="${f:applicationDecode(param.index)}" />
<c:set scope="page" var="listName" value="${f:applicationDecode(param.listName)}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="mdc-card row-container item contatto">
	<html:input type="hidden" mapping="${listName}@${index}.id" />

	<div class="mdc-card__content title">
		<%-- etichetta --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-flex-grow" />
			<jsp:param name="input_ripple" value="false" />
			<jsp:param name="input_mapping" value="${listName}@${index}.nominativo" />
			<jsp:param name="input_placeHolder" value="${f:message(LOCALE, 'Nominativo')}" />
		</jsp:include>

		<%-- menu --%>
		<div class="mdc-menu-surface--anchor menu-ops">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
				<jsp:param name="button_icon" value="more_vert" />
			</jsp:include>
			
			<div class="mdc-menu mdc-menu-surface">
				<ul class="mdc-list" role="menu">
					<li class="mdc-list-item row-container-remove" role="menuitem">
						<span class="mdc-list-item__text"><html:message key="Elimina" /></span>
					</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-full-width" />
			<jsp:param name="input_mapping" value="${listName}@${index}.ruolo" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Ruolo')}" />
		</jsp:include>
	</div>

	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-full-width" />
			<jsp:param name="input_mapping" value="${listName}@${index}.telefono1" />
			<jsp:param name="input_customType" value="link|type=call" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Telefono')} #1" />
		</jsp:include>
	</div>
	
	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-full-width" />
			<jsp:param name="input_mapping" value="${listName}@${index}.telefono2" />
			<jsp:param name="input_customType" value="link|type=call" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Telefono')} #2" />
		</jsp:include>
	</div>
	
	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-full-width" />
			<jsp:param name="input_mapping" value="${listName}@${index}.email" />
			<jsp:param name="input_customType" value="link|type=mail" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Email')}" />
		</jsp:include>
	</div>
	
	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/textarea.html.jsp">
			<jsp:param name="textarea_classBox" value="gpro-full-width" />
			<jsp:param name="textarea_mapping" value="${listName}@${index}.note" />
			<jsp:param name="textarea_caption" value="${f:message(LOCALE, 'Note')}" />
		</jsp:include>
	</div>
</div>