<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%--
	PREFISSO PER PARAMETRI
	–––––––––––––––––––––– 
	telephones_
	
	
	
	PARAMETRI
	–––––––––
	initialClass	→ (default = 'telefoni-box') classe da assegnare al contenitore
	buttonClass		→ (default = 'aggiungi-telefono') classe del pulsante per l'aggiunta di un nuovo item
	listName		→ (default = 'telefoni') nome dell'attributo del BEAN che contiene la lista dei pojo da rappresentare tramite item.html.jsp
	stepName		→ (default = 'telefono') nome dello step da invocare per l'aggiunta di un nuovo item
	embedded		→ (default = false) indica che il contenitore è contenuto nella pagina caricata da loadServletPage
	
	
	
	NOTE
	––––
	Questa pagina potrebbe essere richiamata da un'altra caricata via loadServletPage. In questo caso l'input.initialClass si applicherebbe al target principale
	e non a questo specifico contenitore. In questo caso non bisogna inserire un input.initialClass ma sarà onere della pagina chiamante definire un contenitore
	con le classi necessarie.
	
	La classe "gpro-js-telephones-box" è un marcatore per l'intercettazione via javascrit (prefisso "gpro-js") e non ha funzioni di decorazione CSS.
--%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- CSS & JS --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<input type="hidden" class="requirePageCSS" value="{COMMON}/step/subItems/telephones/default.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/step/subItems/telephones/default.js" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- personalizzazione del target --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="initialClass" value="${not empty param.telephones_initialClass ? param.telephones_initialClass : 'telefoni-box'}" />
<c:set scope="page" var="buttonClass" value="${not empty param.telephones_buttonClass ? param.telephones_buttonClass : 'aggiungi-telefono'}" />
<c:set scope="page" var="listName" value="${not empty param.telephones_listName ? param.telephones_listName : 'telefoni'}" />
<c:set scope="page" var="stepName" value="${not empty param.telephones_stepName ? param.telephones_stepName : 'telefono'}" />

<%-- Parametri ricevuti dalla JSP chiamante e che quindi non sono codificati --%>
<input type="hidden" id="initialClass" value="${initialClass}" />
<input type="hidden" id="buttonClass" value="${buttonClass}" />
<input type="hidden" id="listName" value="${listName}" />
<input type="hidden" id="stepName" value="${stepName}" />

<c:if test="${empty param.telephones_embedded || param.telephones_embedded == 'false' || f:applicationDecode(param.telephones_embedded) == 'false'}">
	<input
		type="hidden"
		class="initialClass"
		value="	gpro-js-telephones-box
				${' '}
				${initialClass}
				${' '}
				${empty BEAN[listName] ? 'with-empty-message' : ''}" />
</c:if>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- empty message --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp">
	<jsp:param name="emptyMessage_hidden" value="${not empty BEAN[listName]}" />
	<jsp:param name="emptyMessage_text" value="nessun_telefono_inserito" />
</jsp:include>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- items --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:forEach items="${BEAN[listName]}" varStatus="status">
	<jsp:include page="item.html.jsp" >
		<jsp:param name="index" value="${f:applicationEncode(status.index)}" />
		<jsp:param name="listName" value="${f:applicationEncode(listName)}" />
	</jsp:include>
</c:forEach>
