<%@ include file="/_core/system/directives.jsp" %>

<%-- -------------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<jsp:include page="/app/_common/step/item/toolbar.html.jsp" />

<input type="hidden" class="requirePageCSS" />

<%-- -------------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<html:input type="hidden" mapping="language" />
<html:input type="hidden" mapping="application" />

<html:input type="hidden" mapping="translation.id" />
<html:input type="hidden" mapping="translation.language" />

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<div>
	<div class="gpro-mdc-text-field-box">
		<div class="mdc-text-field" data-mdc-auto-init="MDCTextField">
			<html:input
				mapping		= "pojo.word"
				dataTransform = "lowercase"
				required	= "true"
				classname	= "mdc-text-field__input app-item-title-source" />
			<label class="mdc-floating-label">Parola chiave</label>
			<div class="mdc-line-ripple"></div>
		</div>		
	</div>
	
	<div class="gpro-mdc-text-field-box">
		<div class="mdc-text-field" data-mdc-auto-init="MDCTextField">
			<html:input
				mapping		= "pojo.bundle"
				classname	= "mdc-text-field__input" />
			<label class="mdc-floating-label">Bundle</label>
			<div class="mdc-line-ripple"></div>
		</div>		
	</div>
</div>

<div class="gpro-mdc-text-field-box x2">
	<div class="mdc-text-field" data-mdc-auto-init="MDCTextField">
		<html:textarea
			mapping		= "translation.value"
			required	= "true"
			rows		= "3"
			classname	= "mdc-text-field__input" />
		<label class="mdc-floating-label">Traduzione in ${f:displayLanguage2(BEAN.language, LOCALE)}</label>
		<div class="mdc-line-ripple"></div>
	</div>		
</div>

<div class="gpro-mdc-text-field-box x2">
	<div class="mdc-text-field" data-mdc-auto-init="MDCTextField">
		<html:textarea
			mapping		= "pojo.note"
			rows		= "3"
			classname	= "mdc-text-field__input" />
		<label class="mdc-floating-label">Note</label>
		<div class="mdc-line-ripple"></div>
	</div>		
</div>

<div class="gpro-mdc-text-field-box x2">
	<div class="mdc-text-field" data-mdc-auto-init="MDCTextField">
		<html:textarea
			mapping		= "translation.note"
			rows		= "3"
			classname	= "mdc-text-field__input" />
		<label class="mdc-floating-label">Note di traduzione</label>
		<div class="mdc-line-ripple"></div>
	</div>		
</div>

<div class="translations">
	<c:if test="${not empty BEAN.valueIt}">
		<div>
			<br /><hr /><br />
			<h6>Traduzione in italiano</h6>
			<br />
			<div>${BEAN.valueIt}</div>
		</div>
	</c:if>
	
	<c:if test="${not empty BEAN.valueEn}">
		<div>
			<br /><hr /><br />
			<h6>Traduzione in inglese</h6>
			<br />
			<div>${BEAN.valueEn}</div>
		</div>
	</c:if>
</div>