<%@ include file="/_core/system/directives.jsp" %>

<%@ page import="it.triware.i18n.Translator" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%
	pageContext.setAttribute("LANGUAGES", Translator.getLanguages());
%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/step/search/toolbar.html.jsp" />

<input type="hidden" class="requirePageCSS" />
<input type="hidden" class="requirePageJS" />

<div class="mdc-theme--surface mdc-theme--on-surface app-search-advanced-container mdc-elevation--z4">
	<div class="gpro-mdc-text-field-box">
		<div class="mdc-text-field" data-mdc-auto-init="MDCTextField">
			<html:select
				mapping		= "language"
				classname	= "mdc-text-field__input">
				<jsp:attribute name="options">
					<c:forEach items="${LANGUAGES}" var="language">
						${language}|${f:displayLanguage2(language, LOCALE)}||
					</c:forEach>
				</jsp:attribute>
			</html:select>
			<label class="mdc-floating-label">Lingua</label>
			<div class="mdc-line-ripple"></div>
			<i class="mdc-select__dropdown-icon"></i>
		</div>
	</div>
	
	<div class="gpro-mdc-text-field-box">
		<div class="mdc-text-field" data-mdc-auto-init="MDCTextField">
			<html:select
				mapping		= "application"
				sorted		= "false"
				classname	= "mdc-text-field__input">
				<jsp:attribute name="options">
					<c:choose>
						<c:when test="${not empty TRANSLATIONS}">
							<c:forEach items="${TRANSLATIONS}" var="translation">
								${translation.codice}|${translation}||
							</c:forEach>
						</c:when>
						<c:otherwise>
							COMMON|Comune||
							APP|Applicazione||
						</c:otherwise>
					</c:choose>
				</jsp:attribute>
			</html:select>
			<label class="mdc-floating-label">Applicazione</label>
			<div class="mdc-line-ripple"></div>
			<i class="mdc-select__dropdown-icon"></i>
		</div>
	</div>
</div>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="mdc-data-table app-search-table-container">
	<table class="mdc-data-table__table app-search-table gpro-data gpro-sortable">
		<thead>
			<tr class="mdc-data-table__header-row">
				<th name="done"		class="mdc-data-table__header-cell gpro-not-sortable gpro-min-width"></th>
				<th name="word"		class="mdc-data-table__header-cell gpro-min-width">word</th>
				<th name="bundle"	class="mdc-data-table__header-cell gpro-min-width">bundle</th>
				<th name="value"	class="mdc-data-table__header-cell">value</th>
				<th name="note"		class="mdc-data-table__header-cell">note</th>
			</tr>
		</thead>
		
		<tbody class="mdc-data-table__content">
		</tbody>

		<tfoot>
			<tr>
				<td>
					<jsp:include page="/app/_common/pagination.html.jsp" />
				</td>
			</tr>
		</tfoot>
	</table>
</div>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- messaggio in caso di ricerca a vuoto --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/emptyMessage.html.jsp" />