<%@ include file="/_core/system/directives.jsp" %>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%
	pageContext.setAttribute("MENU_BACKGROUND", Util.fileExists("app/_custom/_layouts/app/menuBackground.html.jsp") ? "/app/_custom/_layouts/app/menuBackground.html.jsp" : null);
	pageContext.setAttribute("CUSTOM_BACKGROUND", Util.fileExists("app/_custom/_layouts/app/background.jpg") ? "1" : null);
	pageContext.setAttribute("CUSTOM_LOGO", Util.fileExists("app/_custom/_layouts/app/logo.png") ? "1" : null);
	pageContext.setAttribute("HELP_ON_LINE", Boolean.valueOf(it.triware.util.AppSettings.getHelpOnLine()));
	
	pageContext.setAttribute("DEBUG", Boolean.valueOf(Application.isDebug()));
%>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<input type="hidden" class="requirePageCSS" value="app/_layouts/default/css/layout.css" />
<input type="hidden" class="requirePageCSS" value="app/_layouts/default/css/drawer.css" />
<input type="hidden" class="requirePageCSS" value="app/_layouts/default/css/header.css" />
<input type="hidden" class="requirePageCSS" value="app/_layouts/default/css/window.css" />
<input type="hidden" class="requirePageCSS" value="app/_layouts/default/css/search.css" />
<input type="hidden" class="requirePageCSS" value="{FOLDER}/css/status.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/sidebar.js" />
<input type="hidden" class="requirePageJS" value="{COMMON}/popup.js" />
<input type="hidden" class="requirePageJS" value="{CUSTOM}/_layouts/default/popup.js" />

<input type="hidden" class="requirePageJS" value="app/_layouts/default/js/interfaceManager.js" />
<input type="hidden" class="requirePageJS" value="{FOLDER}/js/default.js" />

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<header class="mdc-top-app-bar mdc-elevation--z2 mdc-background-header">
	<%-- barra principale: menu applicazione + menu utente --%>
	<div class="mdc-top-app-bar__row main-top-app-bar__row">
		<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-start">
			<%-- menu applicazione --%>
			<img class="mdc-top-app-bar__section-logo" src="${APPLICATION.contextPath}/app/_custom/img/icon.png" />
			<span class="mdc-top-app-bar__title">${APPLICATION.name}</span>
		</section>
		
		<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-start">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="top-bar-button app-starter" />
				<jsp:param name="button_icon" value="tune" />
				<jsp:param name="button_rel" value="setting" />
				<jsp:param name="button_tag" value="${f:message(LOCALE, 'Impostazioni')}" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Impostazioni')}" />
			</jsp:include>

			<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('WORDPRESS')}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_class" value="top-bar-button app-starter" />
					<jsp:param name="button_icon" value="list_alt" />
					<jsp:param name="button_rel" value="wordpressModel" />
					<jsp:param name="button_tag" value="${f:message(LOCALE, 'Modelli_wordpress')}" />
					<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Modelli_wordpress')}" />
				</jsp:include>
			</c:if>

			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="top-bar-button app-starter" />
				<jsp:param name="button_icon" value="public" />
				<jsp:param name="button_rel" value="virtualHost" />
				<jsp:param name="button_tag" value="${f:message(LOCALE, 'Domini')}" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Domini')}" />
			</jsp:include>

			<c:if test="${DEBUG}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_class" value="top-bar-button app-starter" />
					<jsp:param name="button_icon" value="g_translate" />
					<jsp:param name="button_rel" value="_gPRO_key" />
					<jsp:param name="button_tag" value="Traduzioni" />
					<jsp:param name="button_tooltip" value="Traduzioni" />
				</jsp:include>
			</c:if>
			
			<%--
			<html:separator count="5" />
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_id" value="btnConsole" />
				<jsp:param name="button_class" value="top-bar-button" />
				<jsp:param name="button_icon" value="personal_video" />
				<jsp:param name="button_tooltip" value="Console" />
			</jsp:include>
			--%>
		</section>
		
		<section class="gpro-flex-grow"></section>
		
		<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end">
			<%-- status --%>
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="top-bar-button" />
				<jsp:param name="button_id" value="btnStatus" />
				<jsp:param name="button_icon" value="autorenew" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Stato_del_sistema')}" />
			</jsp:include>
			
			<jsp:include page="status.html.jsp" />

			<%-- help on line --%>
			<c:if test="${HELP_ON_LINE}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_class" value="top-bar-button" />
					<jsp:param name="button_action" value="help-on-line" />
					<jsp:param name="button_icon" value="help_outline" />
				</jsp:include>
			</c:if>

			<%-- menu utente --%>
			<div class="mdc-menu-surface--anchor">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_id" value="appAvatarBox" />
					<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
					<jsp:param name="button_textClass" value="mdc-color-on-primary app-avatar-name" />
					<jsp:param name="button_text" value="${SOGGETTO.getNominativo()}" />
					<jsp:param name="button_src" value="${SOGGETTO.extra.avatar}" />
					<jsp:param name="button_imgFirst" value="false" />
					<jsp:param name="button_useImgTag" value="false" />
				</jsp:include>
				
				<jsp:include page="/app/_common/menuUser.html.jsp" />
			</div>
		</section>
	</div>
</header>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- BACKGROUND + CONTENT --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%-- sfondo --%>
<div class="background ${not empty CUSTOM_BACKGROUND ? 'wallpaper' : ''}">
	<c:if test="${not empty CUSTOM_LOGO}">
		<img class="logo" src="${APPLICATION.contextPath}/app/_custom/_layouts/app/logo.png" />
	</c:if>
</div>

<%-- menu in home --%>
<c:if test="${not empty MENU_BACKGROUND}">
	<div class="background-menu"><jsp:include page="${MENU_BACKGROUND}" /></div>
</c:if>

<%-- div principale "content" --%>
<div class="app-content"></div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- SNACKBAR --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
	
<div class="mdc-snackbar">
	<div class="mdc-snackbar__surface">
		<div class="mdc-snackbar__label" role="status"></div>
		
		<div class="mdc-snackbar__actions">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="mdc-snackbar__dismiss" />
				<jsp:param name="button_icon" value="close" />
			</jsp:include>
		</div>
	</div>
</div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- HELP ON LINE --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<c:if test="${HELP_ON_LINE}">
	<div class="gpro-help mdc-elevation--z4"></div>
</c:if>