<%@ include file="/_core/system/directives.jsp" %>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%
	pageContext.setAttribute("MENU_BACKGROUND", Util.fileExists("/app/_custom/_layouts/default/menuBackground.html.jsp") ? "/app/_custom/_layouts/default/menuBackground.html.jsp" : null);
	pageContext.setAttribute("CUSTOM_BACKGROUND", Util.fileExists("/app/_custom/_layouts/default/background.jpg") ? "1" : null);
	pageContext.setAttribute("CUSTOM_LOGO", Util.fileExists("/app/_custom/_layouts/default/logo.png") ? "1" : null);
	pageContext.setAttribute("CUSTOM_LOGO_BAR", Util.fileExists("/app/_custom/_layouts/default/logo_bar.png") ? "1" : null);
	pageContext.setAttribute("HELP_ON_LINE", Boolean.valueOf(it.triware.util.AppSettings.getHelpOnLine()));
%>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<input type="hidden" class="requirePageCSS" value="{FOLDER}/css/layout.css" />
<input type="hidden" class="requirePageCSS" value="{FOLDER}/css/drawer.css" />
<input type="hidden" class="requirePageCSS" value="{FOLDER}/css/header.css" />
<input type="hidden" class="requirePageCSS" value="{FOLDER}/css/window.css" />
<input type="hidden" class="requirePageCSS" value="{FOLDER}/css/search.css" />

<input type="hidden" class="requirePageJS" value="{COMMON}/sidebar.js" />
<input type="hidden" class="requirePageJS" value="{COMMON}/popup.js" />
<input type="hidden" class="requirePageJS" value="{CUSTOM}/_layouts/default/popup.js" />

<input type="hidden" class="requirePageJS" value="{FOLDER}/js/menu.js" />
<input type="hidden" class="requirePageJS" value="{FOLDER}/js/interfaceManager.js" />

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- MENU DRAWER --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<aside class="mdc-drawer mdc-drawer--modal">
	<jsp:include page="/app/_custom/_layouts/default/menu.html.jsp">
		<jsp:param name="menu_logo" value="${LOGO}" />
	</jsp:include>

	<jsp:include page="/app/_common/menuAdminPlatform.html.jsp" />
</aside>
<div class="mdc-drawer-scrim"></div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<header class="mdc-top-app-bar mdc-elevation--z2 mdc-background-header">
	<%-- barra principale: menu applicazione + menu utente --%>
	<div class="mdc-top-app-bar__row main-top-app-bar__row">
		<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-start">
			<%-- menu applicazione --%>
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="mdc-top-app-bar__navigation-icon drawer-trigger" />
				<jsp:param name="button_icon" value="menu" />
			</jsp:include>

			<c:choose>
				<%-- priorità 1: logo personalizzato per la barra del titolo in questo layout --%>
				<c:when test="${not empty CUSTOM_LOGO_BAR}">
					<img class="mdc-top-app-bar__section-logo" src="${APPLICATION.contextPath}/app/_custom/_layouts/default/logo_bar.png" />
				</c:when>
				<%-- priorità 2: logo personalizzato per questo layout --%>
				<c:when test="${not empty CUSTOM_LOGO}">
					<img class="mdc-top-app-bar__section-logo" src="${APPLICATION.contextPath}/app/_custom/_layouts/default/logo.png" />
				</c:when>
				<%-- priorità 3: logo dell'applicazione --%>
				<c:otherwise>
					<img class="mdc-top-app-bar__section-logo" src="${LOGO}" />
				</c:otherwise>
			</c:choose>
		</section>
		
		<section class="gpro-flex-grow"></section>
		
		<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end">
			<%-- help on line --%>
			<c:if test="${HELP_ON_LINE}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_class" value="top-bar-button" />
					<jsp:param name="button_action" value="help-on-line" />
					<jsp:param name="button_icon" value="help_outline" />
				</jsp:include>
			</c:if>
			
			<%-- switch dei "titolari" (gestione multi-azienda) --%>
			<c:if test="${not empty TITOLARI && fn:length(TITOLARI) > 1}">
				<%-- icona "titolari" --%>
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="separator" />
					<jsp:param name="icon_icon" value="location_city" />
				</jsp:include>

				<%-- menu dei titolari --%>
				<div class="mdc-menu-surface--anchor">
					<jsp:include page="/_core/system/include/button.html.jsp">
						<jsp:param name="button_id" value="btnSwitchTitolare" />
						<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
						<jsp:param name="button_textClass" value="mdc-color-on-primary app-holder-name" />
						<jsp:param name="button_text" value="${TITOLARE.nominativo}" />
					</jsp:include>
					
					<jsp:include page="/app/_common/menuTitolari.html.jsp" />
				</div>
				
				<%-- icona di separazione --%>
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="separator" />
					<jsp:param name="icon_icon" value="arrow_right" />
				</jsp:include>
			</c:if>
			
			<%-- menu utente --%>
			<div class="mdc-menu-surface--anchor">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_id" value="appAvatarBox" />
					<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
					<jsp:param name="button_textClass" value="mdc-color-on-primary app-avatar-name" />
					<jsp:param name="button_text" value="${SOGGETTO.getNominativo()}" />
					<jsp:param name="button_src" value="${f:avatarUrl(SOGGETTO, true, false, false, null, null)}" />
					<jsp:param name="button_imgFirst" value="false" />
					<jsp:param name="button_useImgTag" value="false" />
				</jsp:include>
				
				<jsp:include page="/app/_custom/_layouts/default/menuUser.html.jsp" />
			</div>
		</section>
	</div>
</header>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- BACKGROUND + CONTENT --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%-- sfondo --%>
<div class="background ${not empty CUSTOM_BACKGROUND ? 'wallpaper' : ''}">
	<c:if test="${not empty CUSTOM_LOGO}">
		<img class="logo" src="${APPLICATION.contextPath}/app/_custom/_layouts/default/logo.png" />
	</c:if>
</div>

<%-- menu in home --%>
<c:if test="${not empty MENU_BACKGROUND}">
	<div class="background-menu"><jsp:include page="${MENU_BACKGROUND}" /></div>
</c:if>

<%-- div principale "content" --%>
<div class="app-content"></div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- SNACKBAR --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
	
<div class="mdc-snackbar">
	<div class="mdc-snackbar__surface">
		<div class="mdc-snackbar__label" role="status"></div>
		
		<div class="mdc-snackbar__actions">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="mdc-snackbar__dismiss" />
				<jsp:param name="button_icon" value="close" />
			</jsp:include>
		</div>
	</div>
</div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- HELP ON LINE --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<c:if test="${HELP_ON_LINE}">
	<div class="gpro-help mdc-elevation--z4"></div>
</c:if>