<%@ include file="/_core/system/directives.jsp" %>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%
	pageContext.setAttribute("CUSTOM_BACKGROUND", Util.fileExists("/app/_custom/_login/background.jpg") ? "1" : null);
	pageContext.setAttribute("CUSTOM_TITLE_BACKGROUND", Util.fileExists("/app/_custom/_login/title.jpg") ? "1" : null);
	pageContext.setAttribute("CUSTOM_TITLE_ICON", Util.fileExists("/app/_custom/_login/icon.png") ? "1" : null);
	pageContext.setAttribute("CUSTOM_TITLE_LOGO", Util.fileExists("/app/_custom/_login/logo.png") ? "1" : null);

	pageContext.setAttribute("SUBSCRIBE_JS", Util.fileExists("/app/_custom/_login/subscribe.js") ? "1" : null);
	pageContext.setAttribute("SUBSCRIBE_CSS", Util.fileExists("/app/_custom/_login/subscribe.css") ? "1" : null);
	pageContext.setAttribute("SUBSCRIBE_JSP", Util.fileExists("/app/_custom/_login/subscribe.html.jsp") ? "/app/_custom/_login/subscribe.html.jsp" : null);
%>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<input type="hidden" class="requirePageCSS" />
<c:if test="${not empty SUBSCRIBE_CSS}">
	<input type="hidden" class="requirePageCSS" value="app/_custom/_login/subscribe.css" />
</c:if>

<input type="hidden" class="requirePageJS" />
<c:if test="${not empty SUBSCRIBE_JS}">
	<input type="hidden" class="requirePageJS" value="app/_custom/_login/subscribe.js" />
</c:if>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- apertura del contenitore principale --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<div class="background canvas ${not empty CUSTOM_BACKGROUND ? 'desktop' : ''}"></div>

<div class="container">

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- card principale con le caselle per il login --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%-- login --%>
<div class="mdc-card mdc-elevation--z8">
	<div class="mdc-card__title mdc-background-header ${not empty CUSTOM_TITLE_BACKGROUND ? 'title' : ''}" id="title">
		<h1 class="mdc-typography--headline4">
			<c:choose>
				<%-- icona personalizzata --%>
				<c:when test="${not empty CUSTOM_TITLE_ICON}">
					<img class="logo logo-icon" src="${APPLICATION.contextPath}/app/_custom/_login/icon.png" />
					<span>${APPLICATION.name}</span>
				</c:when>
				
				<%-- logo personalizzato (no titolo) --%>
				<c:when test="${not empty CUSTOM_TITLE_LOGO}">
					<img class="logo" src="${APPLICATION.contextPath}/app/_custom/_login/logo.png" />
				</c:when>
				
				<%-- predefinito --%>
				<c:otherwise>
					<c:choose>
						<%-- nome "vuoto" -> logo --%>
						<c:when test="${empty APPLICATION.name}">
							<img class="logo" src="${LOGO}" />
						</c:when>
						
						<%-- nome non vuoto -> icona + nome app --%>
						<c:otherwise>
							<img class="logo logo-icon" src="${ICON}" />
							<span>${APPLICATION.name}</span>
						</c:otherwise>
					</c:choose>
				</c:otherwise>
			</c:choose>
		</h1>
	</div>
	
	<div class="mdc-card__content" id="inputs">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_maxLength" value="100" />
			<jsp:param name="input_customType" value="link|visibility" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome_utente')}" />
		</jsp:include>

		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_type" value="password" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Password')}" />
		</jsp:include>

		<%-- Conferma per il cambiamento della password --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="ui-helper-hidden" />
			<jsp:param name="input_idBox" value="confirmBox" />
			<jsp:param name="input_id" value="confirmPassword" />
			<jsp:param name="input_type" value="password" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Conferma_password')}" />
		</jsp:include>

		<%-- Codice di sblocco per gli utenti bloccati --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="ui-helper-hidden" />
			<jsp:param name="input_idBox" value="lockBox" />
			<jsp:param name="input_id" value="lockCode" />
			<jsp:param name="input_maxLength" value="20" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Codice_di_sblocco')}" />
			<jsp:param name="input_title" value="${f:message(LOCALE, 'inserisci_codice_sblocco')}" />
		</jsp:include>
		
		<%-- Token per l'autenticazione in 2 fasi --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="ui-helper-hidden" />
			<jsp:param name="input_idBox" value="tokenBox" />
			<jsp:param name="input_id" value="token" />
			<jsp:param name="input_maxLength" value="6" />
			<jsp:param name="input_customType" value="numeric|0|false|true" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Codice_di_sblocco')}" />
			<jsp:param name="input_title" value="${f:message(LOCALE, 'inserisci_token')}" />
		</jsp:include>
	</div>
	
	<%-- pulsante di login --%>
	<div class="mdc-card__actions">
		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_id" value="chkPersistent" />
			<jsp:param name="switch_caption" value="${f:message(LOCALE, 'Resta_collegato')}" />
		</jsp:include>
		
		<span class="gpro-flex-grow"></span>
	
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_id" value="btnLogin" />
			<jsp:param name="button_disabled" value="true" />
			<jsp:param name="button_raised" value="true" />
			<jsp:param name="button_text" value="${f:message(LOCALE, 'Accedi')}" />
		</jsp:include>
  	</div>
  	
  	<%-- social login --%>
	<c:if test="${APPLICATION.socialLogin}">
		<div class="mdc-card__actions social-actions">
			<c:if test="${APPLICATION.socialLoginGoogle}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_id" value="socialBtnGoogle" />
					<jsp:param name="button_src" value="${APPLICATION.contextPath}/app/_common/img/brand/google.png" />
					<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'collegati_con_google')}" />
				</jsp:include>
			</c:if>
	
			<c:if test="${APPLICATION.socialLoginFacebook}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_id" value="socialBtnFacebook" />
					<jsp:param name="button_src" value="${APPLICATION.contextPath}/app/_common/img/brand/facebook.png" />
					<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'collegati_con_facebook')}" />
				</jsp:include>
			</c:if>
	
			<%--
			<c:if test="${APPLICATION.socialLoginLinkedin}">
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_id" value="socialBtnLinkedin" />
					<jsp:param name="button_src" value="${APPLICATION.contextPath}/app/_common/img/brand/linkedin.png" />
					<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'collegati_con_linkedin')}" />
				</jsp:include>
			</c:if>
			--%>
		</div>
	</c:if>
</div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- card secondaria con gli strumenti accesssori (password dmenticata, registrazione...) --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<%-- password dimenticata/registrazione --%>
<div class="mdc-card mdc-elevation--z8">
	<div class="mdc-card__content" id="utils">
		<div>
			<a class="gpro-clickable click-effect underline-effect forgot-password"><html:message key="Password_dimenticata?" /></a>
			<span class="gpro-flex-grow"></span>
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="forgot-password" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Password_dimenticata?')}" />
				<jsp:param name="button_icon" value="vpn_key" />
			</jsp:include>
		</div>
		
		<c:if test="${not empty SUBSCRIBE_JS}">
			<div class="subscribe-box">
				<a class="gpro-clickable click-effect underline-effect subscribe"><html:message key="Iscrizione_link_message" /></a>
				<span class="gpro-flex-grow"></span>
				<jsp:include page="/_core/system/include/button.html.jsp">
					<jsp:param name="button_class" value="subscribe" />
					<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Iscrizione_link_message')}" />
					<jsp:param name="button_icon" value="person_add" />
				</jsp:include>
			</div>
		</c:if>
	</div>
</div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- pulsante credits e snackbar per i messaggi di status --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<jsp:include page="/_core/system/include/button.html.jsp">
	<jsp:param name="button_class" value="credits" />
	<jsp:param name="button_action" value="credits" />
	<jsp:param name="button_tooltip" value="Credits" />
	<jsp:param name="button_icon" value="link" />
</jsp:include>

<div class="mdc-snackbar">
	<div class="mdc-snackbar__surface">
		<div class="mdc-snackbar__label" role="status"></div>
		
		<div class="mdc-snackbar__actions">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="mdc-snackbar__dismiss" />
				<jsp:param name="button_icon" value="close" />
			</jsp:include>
		</div>
	</div>
</div>

<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- chiusura del contenitore principale --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

</div>


<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- contenuto per la procedura di registrazione --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<c:if test="${not empty SUBSCRIBE_JSP}">
	<jsp:include page="${SUBSCRIBE_JSP}" />
</c:if>
