<%@ include file="/_core/system/directives.jsp" %>



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<c:set scope="page" var="noSocialIcon" value="${APPLICATION.contextPath}/app/_common/img/material/clear-black-48dp.svg" />

<jsp:include page="/app/_common/step/item/toolbar.html.jsp">
	<jsp:param name="toolbar_buttonDelete" value="false" />
	<jsp:param name="toolbar_windowSelector" value="true" />
</jsp:include>

<input type="hidden" class="app-item-title-source" value="${f:message(LOCALE, 'Modifica_profilo')}" />



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<c:set scope="page" var="AVATAR" value="none" />
<c:if test="${BEAN.extra.hasCustomAvatar()}">
	<c:set scope="page" var="AVATAR">url('${BEAN.extra.avatar}')</c:set>
</c:if>



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<input type="hidden" class="requirePageCSS" />

<input type="hidden" class="requirePageJS" />



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<html:input type="hidden" mapping="account.id" />



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- avatar, username, password e autenticazione in 2 fasi --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<div>
	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_id" value="btnDeleteAvatar" />
		<jsp:param name="button_icon" value="clear" />
	</jsp:include>

	<div id="avatar" style="background-image: ${AVATAR}" class="${AVATAR != 'none' ? 'has-avatar' : ''}">
		<span id="defaultAvatar">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_icon" value="person" />
			</jsp:include>
		</span>
		
		<span id="uploadAvatar">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_icon" value="cloud_upload" />
			</jsp:include>
		</span>
	</div>
	
	<div class="gpro-display-inline-flex-column">
		<%-- nome, cognome o ragone sociale --%>
		<div>
			<c:choose>
				<c:when test="${BEAN.pojo.azienda}">
					<jsp:include page="/_core/system/include/input.html.jsp">
						<jsp:param name="input_classBox" value="x4_3" />
						<jsp:param name="input_mapping" value="pojo.ragioneSociale" />
						<jsp:param name="input_required" value="true" />
						<jsp:param name="input_caption" value="${f:message(LOCALE, 'Ragione_sociale')}" />
					</jsp:include>
				</c:when>
				<c:otherwise>
					<jsp:include page="/_core/system/include/input.html.jsp">
						<jsp:param name="input_classBox" value="x2_3" />
						<jsp:param name="input_mapping" value="pojo.nome" />
						<jsp:param name="input_required" value="true" />
						<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome')}" />
					</jsp:include>
				
					<jsp:include page="/_core/system/include/input.html.jsp">
						<jsp:param name="input_classBox" value="x2_3" />
						<jsp:param name="input_mapping" value="pojo.cognome" />
						<jsp:param name="input_required" value="true" />
						<jsp:param name="input_caption" value="${f:message(LOCALE, 'Cognome')}" />
					</jsp:include>
				</c:otherwise>
			</c:choose>
		</div>
		
		<%-- email --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_mapping" value="email" />
			<jsp:param name="input_maxLength" value="100" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Email')}" />
		</jsp:include>

		<%-- username --%>		
		<c:set scope="page" var="buttons">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="password-switch" />
				<jsp:param name="button_icon" value="key" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Modifica_password')}" />
			</jsp:include>
		</c:set>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_idBox" value="username" />
			<jsp:param name="input_classBox" value="buttons-visible" />
			<jsp:param name="input_mapping" value="account.username" />
			<jsp:param name="input_required" value="true" />
			<jsp:param name="input_readOnly" value="${!APPLICATION.profiloCambioUsername}" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome_utente')}" />
			<jsp:param name="input_buttons" value="${buttons}" />
		</jsp:include>
		
		<div id="passwordBox" class="ui-helper-hidden">
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_classBox" value="x2_3" />
				<jsp:param name="input_type" value="password" />
				<jsp:param name="input_mapping" value="account.password" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nuova_password')}" />
			</jsp:include>

			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_classBox" value="x2_3" />
				<jsp:param name="input_type" value="password" />
				<jsp:param name="input_id" value="confermaPassword" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Conferma_password')}" />
			</jsp:include>
		</div>
		
		<% pageContext.setAttribute("LANGUAGES", Application.getLanguages().split(",")); %>
		<c:set scope="page" var="options">
			<c:forEach items="${LANGUAGES}" var="language">
				${language}|${f:displayLanguage2(language, LOCALE)}||
			</c:forEach>
		</c:set>
		<jsp:include page="/_core/system/include/select.html.jsp">
			<jsp:param name="select_mapping" value="account.lingua" />
			<jsp:param name="select_caption" value="${f:message(LOCALE, 'Lingua')}" />
			<jsp:param name="select_options" value="${options}" />
		</jsp:include>
	</div>			
</div>



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- autenticazione in due fasi --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<hr />

<div id="autenticazione2FasiContainer">
	<div>
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_class" value="info-icon" />
			<jsp:param name="icon_icon" value="phonelink_lock" />
		</jsp:include>
		
		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_mapping" value="account.autenticazione2Fasi" />
			<jsp:param name="switch_caption" value="${f:message(LOCALE, 'Autenticazione_in_2_fasi')}" />
		</jsp:include>
	</div>

	<div class="${BEAN.account.autenticazione2Fasi ? '' : 'ui-helper-hidden'}" id="autenticazione2FasiBox">
		<div class="gpro-display-flex-row">
			<div class="gpro-display-flex-column gpro-flex-grow">
				<%-- codice --%>
				<c:set scope="page" var="buttons">
					<jsp:include page="/_core/system/include/button.html.jsp">
						<jsp:param name="button_id" value="btnUpdateTotp" />
						<jsp:param name="button_icon" value="refresh" />
						<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Genera_un_nuovo_codice')}" />
					</jsp:include>
				</c:set>
				<jsp:include page="/_core/system/include/input.html.jsp">
					<jsp:param name="input_classBox" value="buttons-visible" />
					<jsp:param name="input_readOnly" value="true" />
					<jsp:param name="input_mapping" value="account.secretKey" />
					<jsp:param name="input_caption" value="${f:message(LOCALE, 'Codice')}" />
					<jsp:param name="input_buttons" value="${buttons}" />
				</jsp:include>
				
				<%-- verifica --%>
				<c:set scope="page" var="buttons">
					<jsp:include page="/_core/system/include/button.html.jsp">
						<jsp:param name="button_id" value="btnTestTotp" />
						<jsp:param name="button_icon" value="compare_arrows" />
						<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Verifica_il_codice_di_sicurezza')}" />
					</jsp:include>
				</c:set>
				<jsp:include page="/_core/system/include/input.html.jsp">
					<jsp:param name="input_classBox" value="buttons-visible" />
					<jsp:param name="input_class" value="not-persistent" />
					<jsp:param name="input_id" value="totpTest" />
					<jsp:param name="input_maxLength" value="6" />
					<jsp:param name="input_caption" value="${f:message(LOCALE, 'Token_verifica')}" />
					<jsp:param name="input_buttons" value="${buttons}" />
				</jsp:include>

				<%-- link per scaricare la app --%>
				<div id="totpInfo" class="gpro-display-flex-row-center">
					<div>
						<img src="${APPLICATION.contextPath}/app/_common/img/brand/googleAuthenticator.png" />
					</div>
					
					<div>
						<a target="_blank" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2" class="gpro-clickable underline-effect click-effect">
							<span>Google Authenticator - Google Play</span>
							<span class="material-icons">launch</span>
						</a>
						<a target="_blank" href="https://itunes.apple.com/it/app/google-authenticator/id388497605" class="gpro-clickable underline-effect click-effect">
							<span>Google Authenticator - App Store</span>
							<span class="material-icons">launch</span>
						</a>
					</div>
				</div>
			</div>

			<span><html:separator /></span>
			
			<img id="totpImg" class="gpro-block" title="${f:message(LOCALE, 'Aggiungi_questo_codice_alla_tua_applicazione_di_autenticazione')}" />
		</div>
	</div>
</div>



<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>
<%-- gravatar e social --%>
<%-- ----------------------------------------------------------------------------------------------------------------------------------------------------- --%>

<hr />

<div id="avatarSocial">
	<div class="social" id="gravatarBox">
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_id" value="btnGravatarDel" />
			<jsp:param name="button_icon" value="remove_circle_outline" />
		</jsp:include>
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_id" value="btnGravatarLink" />
			<jsp:param name="button_icon" value="add_circle_outline" />
		</jsp:include>
	
		<img class="icon" src="${not empty BEAN.extra.gravatar ? BEAN.extra.gravatar : noSocialIcon}" />
		<a target="_blank" href="https://www.google.com/search?q=gravatar" class="gpro-clickable underline-effect click-effect">
			<span>Gravatar</span>
			<span class="material-icons">launch</span>
		</a>
	</div>

	<c:if test="${APPLICATION.socialLogin}">	
		<div class="social" id="googleBox">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_id" value="btnGoogleDel" />
				<jsp:param name="button_icon" value="remove_circle_outline" />
			</jsp:include>
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_id" value="btnGoogleLink" />
				<jsp:param name="button_icon" value="add_circle_outline" />
			</jsp:include>

			<img class="icon" src="${not empty BEAN.extra.googleAvatar ? BEAN.extra.googleAvatar : noSocialIcon}" />
			Google
		</div>
		
		<div class="social" id="facebookBox">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_id" value="btnFacebookDel" />
				<jsp:param name="button_icon" value="remove_circle_outline" />
			</jsp:include>
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_id" value="btnFacebookLink" />
				<jsp:param name="button_icon" value="add_circle_outline" />
			</jsp:include>
			
			<img class="icon" src="${not empty BEAN.extra.facebookAvatar ? BEAN.extra.facebookAvatar : noSocialIcon}" />
			Facebook
		</div>

		<%--
		<div class="social" id="linkedinBox">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_id" value="btnLinkedinDel" />
				<jsp:param name="button_icon" value="remove_circle_outline" />
			</jsp:include>
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_id" value="btnLinkedinLink" />
				<jsp:param name="button_icon" value="add_circle_outline" />
			</jsp:include>
			
			<img class="icon" src="${not empty BEAN.extra.linkedinAvatar ? BEAN.extra.linkedinAvatar : noSocialIcon}" />
			<img class="badge" src="${APPLICATION.contextPath}/app/_common/logos/linkedinBadge.png" />
		</div>
		--%>
	</c:if>
</div>	
