<%@ include file="/_core/system/directives.jsp" %>



<%@ page import="application.util.AppSettings" %>
<%@ page import="application.orm.persister.PhpFinder" %>

<%
	pageContext.setAttribute("PHPS", PhpFinder.getInstance().getAll());
%>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/step/item/toolbar.html.jsp">
	<jsp:param name="toolbar" value="false" />
	<jsp:param name="item_checkEditing" value="false" />
</jsp:include>

<input type="hidden" class="app-item-title-alt" value="${f:message(LOCALE, 'Preferenze')}" />

<input type="hidden" class="requirePageCSS" />

<input type="hidden" class="requirePageJS" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="mdc-card gpro-full-width">
	<div class="mdc-card__title mdc-background-secondary"><html:message key="Informazioni" /></div>
	
	<div class="mdc-card__content">
		<div class="gpro-display-table gpro-full-width info-table">
			<div class="thead">
				<div>server</div>
				<div>ip</div>
				<div><html:message key="taglia" /></div>
			</div>
			
			<div class="tbody">
				<div class="gpro-selectable">srv<%= AppSettings.getSrvNumber() %>.<%= AppSettings.getSrvOwner() %></div>
				<div>
					<div class="gpro-selectable"><%= AppSettings.getSrvIpv4Address() %></div>
					<div class="gpro-selectable"><%= AppSettings.getSrvIpv6Address() %></div>
				</div>
				<div><%= AppSettings.getSrvSize() %></div>
			</div>
		</div>
	</div>
</div>

<br />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%-- PHP --%>
<div class="mdc-card">
	<div class="mdc-card__title"><html:message key="Setting_default_php" /></div>
	
	<div class="mdc-card__content">
		<c:set scope="page" var="options">
			<c:forEach items="${PHPS}" var="php">
				${php.id}|${php.versione}||
			</c:forEach>
		</c:set>
		<jsp:include page="/_core/system/include/select.html.jsp">
			<jsp:param name="select_classBox" value="xauto" />
			<jsp:param name="select_mapping" value="idPhp" />
			<jsp:param name="select_options" value="${options}" />
			<jsp:param name="select_caption" value="PHP" />
		</jsp:include>
	</div>
</div>

<%-- Backup --%>
<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('BACKUPADV')}">
	<div class="mdc-card">
		<div class="mdc-card__title">Backup</div>
	
		<div class="mdc-card__content">
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_classBox" value="x1_2 gpro-vertical-align-middle" />
				<jsp:param name="input_required" value="true" />
				<jsp:param name="input_customType" value="numberic|decimalDigits=0|thousandsSeparator=false|nullable=false|negative=false|emptyIfZero=false" />
				<jsp:param name="input_mapping" value="backupSets" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Backup_sets')}" />
			</jsp:include>
	
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_classBox" value="x1_2 gpro-vertical-align-middle" />
				<jsp:param name="input_required" value="true" />
				<jsp:param name="input_customType" value="numberic|decimalDigits=0|thousandsSeparator=false|nullable=false|negative=false|emptyIfZero=false" />
				<jsp:param name="input_mapping" value="backupShifts" />
				<jsp:param name="input_caption" value="${f:message(LOCALE, 'Backup_shifts')}" />
			</jsp:include>
	
			<jsp:include page="/_core/system/include/switch.html.jsp">
				<jsp:param name="switch_mapping" value="backupFtp" />
				<jsp:param name="switch_caption" value="${f:message(LOCALE, 'Backup_ftp')}" />
			</jsp:include>
		</div>
	</div>
</c:if>

<%-- Wordpress --%>
<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('WORDPRESS')}">
	<div class="mdc-card">
		<div class="mdc-card__title">Wordpress</div>
	
		<div class="mdc-card__content">
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_mapping" value="wordpressAdminUsername" />
				<jsp:param name="input_caption" value="Admin user" />
			</jsp:include>
	
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_type" value="password" />
				<jsp:param name="input_customType" value="link|visibility" />
				<jsp:param name="input_dataTransform" value="clear" />
				<jsp:param name="input_mapping" value="wordpressAdminPassword" />
				<jsp:param name="input_caption" value="Admin password" />
			</jsp:include>
	
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_mapping" value="wordpressAdminEmail" />
				<jsp:param name="input_caption" value="Admin email" />
			</jsp:include>
		</div>
	
		<div class="mdc-card__content wordpress-extras">
			<%-- locales --%>
			<div class="wordpress-extra">
				<h4>
					<jsp:include page="/_core/system/include/button.html.jsp">
						<jsp:param name="button_icon"		value="language" />
						<jsp:param name="button_tooltip"	value="${f:message(LOCALE, 'Lingue')}" />
					</jsp:include>
					<html:message key="Lingue" />
				</h4>
				
				<jsp:include page="/_core/system/include/textarea.html.jsp">
					<jsp:param name="textarea_mapping" value="wordpressLocales" />
				</jsp:include>
			</div>
	
			<%-- themes --%>
			<div class="wordpress-extra themes">
				<h4>
					<jsp:include page="/_core/system/include/button.html.jsp">
						<jsp:param name="button_class"		value="aggiungi-tema" />
						<jsp:param name="button_icon"		value="add_circle" />
						<jsp:param name="button_tooltip"	value="${f:message(LOCALE, 'Aggiungi_tema')}" />
					</jsp:include>
					<html:message key="Temi" />
				</h4>
				
				<jsp:include page="/_core/system/include/textarea.html.jsp">
					<jsp:param name="textarea_mapping" value="wordpressThemes" />
				</jsp:include>
				
				<c:forEach items="${BEAN.themes}" var="theme">
					<jsp:include page="extra.html.jsp">
						<jsp:param name="fileName" value="${f:applicationEncode(theme)}" />
					</jsp:include>
				</c:forEach>
			</div>
	
			<%-- plugins --%>
			<div class="wordpress-extra plugins">
				<h4>
					<jsp:include page="/_core/system/include/button.html.jsp">
						<jsp:param name="button_class"		value="aggiungi-plugin" />
						<jsp:param name="button_icon"		value="add_circle" />
						<jsp:param name="button_tooltip"	value="${f:message(LOCALE, 'Aggiungi_plugin')}" />
					</jsp:include>
					Plugins
				</h4>
				
				<jsp:include page="/_core/system/include/textarea.html.jsp">
					<jsp:param name="textarea_mapping" value="wordpressPlugins" />
				</jsp:include>
	
				<c:forEach items="${BEAN.plugins}" var="plugin">
					<jsp:include page="extra.html.jsp">
						<jsp:param name="fileName" value="${f:applicationEncode(plugin)}" />
					</jsp:include>
				</c:forEach>
			</div>
		</div>
	</div>
</c:if>

<%-- IP White list --%>
<div class="mdc-card">
	<div class="mdc-card__title">IP white list</div>

	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/textarea.html.jsp">
			<jsp:param name="textarea_mapping" value="ipWhiteList" />
			<jsp:param name="textarea_placeHolder" value="IP list" />
		</jsp:include>
	</div>
</div>
