<%@ include file="/_core/system/directives.jsp" %>

<%@ page import="application.util.AppSettings" %>
<%@ page import="application.orm.persister.PhpPersister" %>

<%
	pageContext.setAttribute("SRV", "srv".concat(AppSettings.getSrvNumber()).concat(".").concat(AppSettings.getSrvOwner()));
%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- toolbar --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<jsp:include page="/app/_common/step/item/toolbar.html.jsp">
	<jsp:param name="item_sidebar" value="true" />
	<jsp:param name="toolbar_buttonDelete" value="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('VHDEL') || BEAN.pojo.staging}" />
</jsp:include>

<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end app-window__toolbar--secondary">
	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button site-navigate-to" />
		<jsp:param name="button_rel" value="item" />
		<jsp:param name="button_icon" value="public" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Vai_al_sito')}" />
	</jsp:include>
	<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('STATS')}">
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_class" value="sidebar-button site-stats" />
			<jsp:param name="button_tag" value="${SRV}" />
			<jsp:param name="button_rel" value="item" />
			<jsp:param name="button_icon" value="analytics" />
			<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Statistiche')}" />
		</jsp:include>
	</c:if>
	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button site-check" />
		<jsp:param name="button_rel" value="item" />
		<jsp:param name="button_icon" value="quiz" />
		<jsp:param name="button_tooltip" value="check.php" />
	</jsp:include>
	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button site-test" />
		<jsp:param name="button_rel" value="item" />
		<jsp:param name="button_icon" value="checklist" />
		<jsp:param name="button_tooltip" value="test.php" />
	</jsp:include>
	<span rel="item">|</span>


	<%-- menu di download dei logs --%>
	<c:set scope="page" var="relPhp" value="<%= PhpPersister.getInstance().getByPrimaryKey(AppSettings.getIdPhp()).getCodice() %>" />
	<c:if test="${BEAN.pojo.idPhp != null}">
		<c:set scope="page" var="relPhp" value="${BEAN.pojo.php.codice}" />
	</c:if>
	<div class="mdc-menu-surface--anchor">
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_class" value="sidebar-button gpro-mdc-menu-surface--anchor-trigger logs" />
			<jsp:param name="button_rel" value="item" />
			<jsp:param name="button_icon" value="bug_report" />
			<jsp:param name="button_tooltip" value="Download logs" />
		</jsp:include>
		
		<div class="mdc-menu mdc-menu-surface">
			<ul class="mdc-list" role="menu">
				<li class="mdc-list-item download-log" role="menuitem" rel="httpd">
					<span class="mdc-list-item__text">HTTP server</span>
				</li>
				<li class="mdc-list-item download-log" role="menuitem" rel="php" data-php="${relPhp}">
					<span class="mdc-list-item__text">PHP</span>
				</li>
				<li class="mdc-list-item download-log" role="menuitem" rel="vh" data-dominio="${BEAN.pojo.dominio.nome}">
					<span class="mdc-list-item__text">Virtual host</span>
				</li>
			</ul>
		</div>
	</div>

	
	<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('STAGING')}">
		<c:if test="${!BEAN.pojo.staging}">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="sidebar-button stage" />
				<jsp:param name="button_rel" value="item" />
				<jsp:param name="button_icon" value="copy_all" />
				<jsp:param name="button_tooltip" value="Staging" />
			</jsp:include>
		</c:if>
	</c:if>

	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button wordpress ${BEAN.pojo.wordpress ? ' installed ' : ' not-installed '}" />
		<jsp:param name="button_rel" value="wordpress" />
		<jsp:param name="button_icon_lib_fa" value="true" />
		<jsp:param name="button_icon" value="fab fa-wordpress" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, BEAN.pojo.wordpress ? 'Amministrazione' : 'Installa_wordpress')}" />
	</jsp:include>

	<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('VHPAUSE')}">
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_class" value="sidebar-button pause" />
			<jsp:param name="button_rel" value="item" />
			<jsp:param name="button_step" value="${BEAN.pojo.sospeso ? 'restart' : 'pause'}" />
			<jsp:param name="button_icon" value="${BEAN.pojo.sospeso ? 'not_started' : 'pause'}" />
			<jsp:param name="button_tooltip" value="${f:message(LOCALE, BEAN.pojo.sospeso ? 'Ripristina' : 'Sospendi')}" />
		</jsp:include>
	</c:if>
	
	<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('VHARCHIVE')}">
		<jsp:include page="/_core/system/include/button.html.jsp">
			<jsp:param name="button_class" value="sidebar-button archive" />
			<jsp:param name="button_rel" value="item" />
			<jsp:param name="button_step" value="${BEAN.pojo.archiviato ? 'unarchive' : 'archive'}" />
			<jsp:param name="button_icon" value="${BEAN.pojo.archiviato ? 'unarchive' : 'archive'}" />
			<jsp:param name="button_tooltip" value="${f:message(LOCALE, BEAN.pojo.archiviato ? 'Ripristina' : 'Archivia')}" />
		</jsp:include>
	</c:if>

	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button backup" />
		<jsp:param name="button_rel" value="backups" />
		<jsp:param name="button_icon" value="save" />
		<jsp:param name="button_tooltip" value="Backup" />
	</jsp:include>
</section>

<section class="mdc-top-app-bar__section mdc-top-app-bar__section--align-end app-window__toolbar--extra">
	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button aggiungi-allegato" />
		<jsp:param name="button_rel" value="allegati" />
		<jsp:param name="button_icon" value="playlist_add" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Aggiungi_allegato')}" />
	</jsp:include>

	<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('DBADD')}">
		<c:if test="${!BEAN.pojo.staging}">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="sidebar-button aggiungi-database" />
				<jsp:param name="button_rel" value="databases" />
				<jsp:param name="button_icon" value="playlist_add" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Aggiungi_database')}" />
			</jsp:include>
		</c:if>
	</c:if>

	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button aggiungi-ftp" />
		<jsp:param name="button_rel" value="ftps" />
		<jsp:param name="button_icon" value="playlist_add" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Aggiungi_accesso_ftp')}" />
	</jsp:include>

	<jsp:include page="/_core/system/include/button.html.jsp">
		<jsp:param name="button_class" value="sidebar-button refresh" />
		<jsp:param name="button_rel" value="backups" />
		<jsp:param name="button_icon" value="refresh" />
		<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Aggiorna')}" />
	</jsp:include>
</section>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- tabs --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="section--sidebar__tabs with-icons">
	<%-- item --%>
	<div class="section--sidebar__tab start" rel="item">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="public" />
		</jsp:include>
		<html:message key="Scheda" />
	</div>
	
	<%-- allegati --%>
	<div class="section--sidebar__tab" rel="allegati">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="attach_file" />
		</jsp:include>
		<html:message key="Allegati" />
	</div>
	
	<%-- databases --%>
	<div class="section--sidebar__tab" rel="databases">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="storage" />
		</jsp:include>
		<html:message key="Database" />
	</div>
	
	<%-- ftps --%>
	<div class="section--sidebar__tab" rel="ftps">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_lib_fa" value="true" />
			<jsp:param name="icon_icon" value="fas fa-download" />
		</jsp:include>
		FTP
	</div>
	
	<%-- backup --%>
	<div class="section--sidebar__tab pojo-stored" rel="backups">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="build" />
		</jsp:include>
		Backup
	</div>

	<%-- wordpress --%>
	<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('WORDPRESS')}">
		<div class="section--sidebar__tab pojo-stored" rel="wordpress">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_lib_fa" value="true" />
				<jsp:param name="icon_icon" value="fab fa-wordpress" />
			</jsp:include>
			Wordpress
		</div>
	</c:if>
</div>



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- pannelli --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div class="section--sidebar__panes"></div>