<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%--
	NOTE - il chiamante deve impostare in request (o in scope raggiungibile) l'oggetto da disegnare con nome "pojo"
--%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	class="mdc-card gpro-on-hover-container ${POJO.sospeso ? ' alert ' : ''} ${POJO.hasTaskAttivo() ? ' task-attivo stripes' : ''}"
	data-id="${POJO.id}"
	data-key="${f:formatForHTML(POJO.infoLabel)}">
	
	<div class="top">
		<div class="title">
			<c:choose>
				<c:when test="${POJO.hasTaskAttivo()}">
					<h3>${f:formatForHTML(POJO.dominioNome)}</h3>
				</c:when>
				<c:otherwise>
					<h3 class="underline-effect click-effect" action="edit">${f:formatForHTML(POJO.dominioNome)}</h3>
				</c:otherwise>
			</c:choose>

			<c:if test="${POJO.alert}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_icon" value="warning" />
					<jsp:param name="icon_class" value="feature condition-foreground alert" />
				</jsp:include>
			</c:if>
						
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_class" value="feature https ${POJO.https ?  (POJO.alertDns ? ' condition-foreground alert ' : '') : ' error '}" />
				<jsp:param name="icon_icon" value="${POJO.https ? ' https ' : ' no_encryption '}" />
			</jsp:include>
			
			<c:if test="${POJO.ftp}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="feature ftp" />
					<jsp:param name="icon_lib_fa" value="true" />
					<jsp:param name="icon_icon" value="fas fa-download" />
				</jsp:include>
			</c:if>
			
			<c:if test="${POJO.cdn}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="feature cdn" />
					<jsp:param name="icon_icon" value="public" />
				</jsp:include>
			</c:if>

			<c:if test="${POJO.statistiche}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="feature analytics" />
					<jsp:param name="icon_icon" value="analytics" />
				</jsp:include>
			</c:if>

			<c:if test="${POJO.staging}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="feature staging" />
					<jsp:param name="icon_icon" value="copy_all" />
				</jsp:include>
			</c:if>

			<c:if test="${POJO.wordpress}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="feature wordpress ${POJO.wordpressDaAggiornare ? ' error ' : ''}" />
					<jsp:param name="icon_lib_fa" value="true" />
					<jsp:param name="icon_icon" value="fab fa-wordpress" />
				</jsp:include>
				
				<span class="gpro-font-size-small">${POJO.wordpressVersione}</span>
			</c:if>
			<c:if test="${POJO.magento}">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_class" value="feature magento" />
					<jsp:param name="icon_lib_fa" value="true" />
					<jsp:param name="icon_icon" value="fab fa-magento" />
				</jsp:include>
			</c:if>
			<c:if test="${POJO.vtiger}">
				<img src="${APPLICATION.contextPath}/app/_custom/img/vtiger.png" class="feature vtiger" />
			</c:if>
			<c:if test="${POJO.angular}">
				<img src="${APPLICATION.contextPath}/app/_custom/img/angular.png" class="feature angular" />
			</c:if>
		</div>
		
		<c:if test="${POJO.sospeso}"><strong class="alert"><html:message key="Dominio_sospeso" /></strong></c:if>
		
		<c:choose>
			<c:when test="${POJO.hasTaskAttivo()}">
				<strong class="task-message">
					<c:choose>
						<c:when test="${POJO.taskOperazione == 1}">
							<html:message key="Backup_in_corso_message" />
						</c:when>
						<c:when test="${POJO.taskOperazione == 2}">
							<html:message key="Restore_in_corso_message" />
						</c:when>
						<c:when test="${POJO.taskOperazione == 3}">
							<html:message key="Staging_in_corso_message" />
						</c:when>
					</c:choose>
				</strong>
			</c:when>
			<c:otherwise>
				<div class="buttons gpro-visible-on-hover">
					<c:if test="${!POJO.hasTaskAttivo()}">
						<jsp:include page="/_core/system/include/button.html.jsp">
							<jsp:param name="button_icon" value="edit" />
							<jsp:param name="button_action" value="edit" />
							<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Modifica')}" />
						</jsp:include>
					</c:if>
					<%--
					<jsp:include page="/_core/system/include/button.html.jsp">
						<jsp:param name="button_icon" value="info" />
						<jsp:param name="button_action" value="info" />
						<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Dettagli')}" />
					</jsp:include>
					--%>
				</div>
			</c:otherwise>
		</c:choose>
	</div>
	
	<c:if test="${not empty POJO.descrizione}">
		<div class="body">${f:formatForHTML(POJO.descrizione)}</div>
	</c:if>

	<c:if test="${not empty POJO.note}">
		<div class="note">${f:formatForHTML(POJO.note)}</div>
	</c:if>
	
	<c:if test="${POJO.alert}">
		<div class="note condition-background alert">
			<c:if test="${POJO.alertDns}">
				<p>
					<jsp:include page="/_core/system/include/icon.html.jsp">
						<jsp:param name="icon_icon" value="public_off" />
					</jsp:include>
					<html:separator />
					<span class="gpro-vertical-align-middle"><html:message key="Alert_dns_message" /></span>
				</p>
			</c:if>
			<c:if test="${POJO.alertHttps}">
				<p>
					<jsp:include page="/_core/system/include/icon.html.jsp">
						<jsp:param name="icon_icon" value="https" />
					</jsp:include>
					<html:separator />
					<span class="gpro-vertical-align-middle"><html:message key="Alert_https_message" /></span>
				</p>
			</c:if>
		</div>
	</c:if>
</div>