<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="index" value="${f:applicationDecode(param.index)}" />
<c:set scope="page" var="item" value="${BEAN.backups.get(index)}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	class="item mdc-theme--surface mdc-theme--on-surface mdc-elevation--z1 ${item.running ? ' running ' : ''}"
	data-dominio="${item.dominio}"
	data-name="${item.name}"
	data-automatic="${item.automatic}"
	data-set="${item.set}"
	data-shift="${item.shift}"
	data-shift-start="${item.shiftStart}"
	>
	<%-- icon --%>
	<div class="type">
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_icon" value="${item.running ? 'loop' : item.automatic ? 'schedule' : 'handyman'}" />
			<jsp:param name="icon_tooltip" value="${f:message(LOCALE, item.automatic ? 'Automatico' : 'Manuale')}" />
		</jsp:include>
	</div>

	<%-- virtual host --%>
	<div>
		<c:if test="${item.virtualHost}">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_icon" value="folder_open" />
				<jsp:param name="icon_tooltip" value="Directory" />
			</jsp:include>
		</c:if>
	</div>

	<%-- databases --%>
	<div>
		<c:if test="${not empty item.databases}">
			<jsp:include page="/_core/system/include/icon.html.jsp">
				<jsp:param name="icon_icon" value="storage" />
				<jsp:param name="icon_tooltip" value="Databases: ${item.databasesNames}" />
			</jsp:include>
		</c:if>
	</div>

	<%-- data --%>
	<div class="data gpro-flex-grow">
		${f:formatDateTime(TIMEZONE, LOCALE, item.date, 0, 2)}
	</div>

	<c:if test="${item.complete}">
		<%-- dimensione --%>
		<div>
			${item.getSizeLabel(LOCALE)}
		</div>
		
		<%-- menu ops --%>
		<div class="mdc-menu-surface--anchor menu-ops">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
				<jsp:param name="button_icon" value="more_vert" />
			</jsp:include>
			
			<div class="mdc-menu mdc-menu-surface menu-ops">
				<ul class="mdc-list" role="menu">
					<li class="mdc-list-item restore" role="menuitem">
						<span class="mdc-list-item__text">Restore</span>
					</li>
	
					<c:if test="${item.manual}">
						<li class="mdc-list-item delete" role="menuitem">
							<span class="mdc-list-item__text"><html:message key="Elimina" /></span>
						</li>
					</c:if>
					
					<%-- download dei singoli file (solo per i backup manuali) --%>
					<c:if test="${item.manual && (item.virtualHost || not empty item.databases)}">
						<li class="mdc-list-divider" role="separator"></li>
						
						<c:if test="${item.virtualHost}">
							<li class="mdc-list-item download-file" role="menuitem" data-file="vh.tar.gz">
								<span class="mdc-list-item__text">Download virtual host</span>
							</li>	
						</c:if>
						
						<c:forEach items="${item.databases}" var="database">
							<li class="mdc-list-item download-file" role="menuitem" data-file="${database}.sql.gz">
								<span class="mdc-list-item__text">Download ${database}</span>
							</li>	
						</c:forEach>	
					</c:if>
				</ul>
			</div>
		</div>
	</c:if>
</div>