<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="index" value="${f:applicationDecode(param.index)}" />
<c:set scope="page" var="item" value="${BEAN.databases.get(index)}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	class="mdc-card row-container database item"
	data-id="${item.id}"
>
	<html:input type="hidden" mapping="databases@${index}.id" />
	<html:input type="hidden" mapping="databases@${index}.applicazioni" />

	<div class="mdc-card__content gpro-display-flex-row-center title">
		<%-- nome del database --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="gpro-flex-grow" />
			<jsp:param name="input_mapping" value="databases@${index}.nome" />
			<jsp:param name="input_readOnly" value="true" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome')}" />
		</jsp:include>
		
		<%-- icona flag wordpress --%>
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_class" value="feature wordpress ${item.applicazioneWordpress ? '' : ' ui-helper-hidden '}" />
			<jsp:param name="icon_lib_fa" value="true" />
			<jsp:param name="icon_icon" value="fab fa-wordpress" />
		</jsp:include>

		<%-- icona flag magento --%>
		<jsp:include page="/_core/system/include/icon.html.jsp">
			<jsp:param name="icon_class" value="feature magento ${item.applicazioneMagento ? '' : ' ui-helper-hidden '}" />
			<jsp:param name="icon_lib_fa" value="true" />
			<jsp:param name="icon_icon" value="fab fa-magento" />
		</jsp:include>

		<%-- icona flag vtiger --%>
		<img src="${APPLICATION.contextPath}/app/_custom/img/vtiger.png" class="feature vtiger ${item.applicazioneVtiger ? '' : ' ui-helper-hidden '}" />
	</div>

	<div class="mdc-card__content">
		<%-- username  --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_mapping" value="databases@${index}.username" />
			<jsp:param name="input_readOnly" value="true" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome_utente')}" />
		</jsp:include>

		<%-- password --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_type" value="password" />
			<jsp:param name="input_dataTransform" value="clear" />
			<jsp:param name="input_customType" value="link|visibility" />
			<jsp:param name="input_mapping" value="databases@${index}.password" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Password')}" />
		</jsp:include>
	</div>

	<div class="mdc-card__content adjacent">
		<%-- descrizione --%>
		<div>
			<jsp:include page="/_core/system/include/textarea.html.jsp">
				<jsp:param name="textarea_classBox" value="x2" />
				<jsp:param name="textarea_mapping" value="databases@${index}.descrizione" />
				<jsp:param name="textarea_caption" value="${f:message(LOCALE, 'Descrizione')}" />
			</jsp:include>
		</div>

		<%-- note --%>
		<div>
			<jsp:include page="/_core/system/include/textarea.html.jsp">
				<jsp:param name="textarea_classBox" value="x2" />
				<jsp:param name="textarea_mapping" value="databases@${index}.note" />
				<jsp:param name="textarea_caption" value="${f:message(LOCALE, 'Note')}" />
			</jsp:include>
		</div>
	</div>
	
	<div class="mdc-card__content adjacent gpro-display-flex-row">
		<%-- backup + menu --%>
		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_mapping" value="databases@${index}.backup" />
			<jsp:param name="switch_icon" value="shield" />
			<jsp:param name="switch_caption" value="Backup" />
		</jsp:include>
		
		<span class="gpro-flex-grow"></span>

		<div class="mdc-menu-surface--anchor menu-ops">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
				<jsp:param name="button_icon" value="more_vert" />
			</jsp:include>
			
			<div class="mdc-menu mdc-menu-surface menu-ops">
				<ul class="mdc-list" role="menu">
					<li class="mdc-list-item" role="menuitem" action="switch-applicazione" data-applicazione="wordpress" data-mask="1">
						<jsp:include page="/_core/system/include/icon.html.jsp">
							<jsp:param name="icon_class" value="mdc-list-item__graphic" />
							<jsp:param name="icon_icon" value="sync_alt" />
						</jsp:include>
						<span class="mdc-list-item__text">Wordpress</span>
					</li>

					<li class="mdc-list-item" role="menuitem" action="switch-applicazione" data-applicazione="magento" data-mask="2">
						<jsp:include page="/_core/system/include/icon.html.jsp">
							<jsp:param name="icon_class" value="mdc-list-item__graphic" />
							<jsp:param name="icon_icon" value="sync_alt" />
						</jsp:include>
						<span class="mdc-list-item__text">Magento</span>
					</li>
				
					<li class="mdc-list-item" role="menuitem" action="switch-applicazione" data-applicazione="vtiger" data-mask="4">
						<jsp:include page="/_core/system/include/icon.html.jsp">
							<jsp:param name="icon_class" value="mdc-list-item__graphic" />
							<jsp:param name="icon_icon" value="sync_alt" />
						</jsp:include>
						<span class="mdc-list-item__text">Vtiger</span>
					</li>
				
					<li class="mdc-list-divider" role="separator"></li>
				
					<li class="mdc-list-item" role="menuitem" action="backup">
						<span class="mdc-list-item__text">Backup</span>
					</li>
					
					<c:if test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('DBDEL')}">
						<c:if test="${!BEAN.pojo.staging}">
							<li class="mdc-list-item" role="menuitem">
								<span class="mdc-list-item__text row-container-remove"><html:message key="Elimina" /></span>
							</li>
						</c:if>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
</div>