<%@ include file="/_core/system/directives.jsp" %>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<c:set scope="page" var="index" value="${f:applicationDecode(param.index)}" />
<c:set scope="page" var="item" value="${BEAN.ftps.get(index)}" />

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<div
	class="mdc-card row-container item ftp"
	data-id="${item.id}"
>
	<html:input type="hidden" mapping="ftps@${index}.id" />

	<%-- username + password --%>
	<div class="mdc-card__content">
		<%-- username --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_mapping" value="ftps@${index}.username" />
			<jsp:param name="input_readOnly" value="true" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Nome_utente')}" />
		</jsp:include>

		<%-- password --%>
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_type" value="password" />
			<jsp:param name="input_dataTransform" value="clear" />
			<jsp:param name="input_customType" value="link|visibility" />
			<jsp:param name="input_mapping" value="ftps@${index}.password" />
			<jsp:param name="input_caption" value="${f:message(LOCALE, 'Password')}" />
		</jsp:include>
	</div>
	
	<%-- home folder --%>
	<div class="mdc-card__content adjacent">
		<jsp:include page="/_core/system/include/input.html.jsp">
			<jsp:param name="input_classBox" value="x2" />
			<jsp:param name="input_mapping" value="ftps@${index}.homeFolder" />
			<jsp:param name="input_caption" value="Home" />
		</jsp:include>
	</div>
	
	<%-- descrizione --%>
	<div class="mdc-card__content adjacent">
		<jsp:include page="/_core/system/include/textarea.html.jsp">
			<jsp:param name="textarea_classBox" value="x2" />
			<jsp:param name="textarea_mapping" value="ftps@${index}.descrizione" />
			<jsp:param name="textarea_caption" value="${f:message(LOCALE, 'Descrizione')}" />
		</jsp:include>
	</div>

	<%-- note --%>
	<div class="mdc-card__content adjacent">
		<jsp:include page="/_core/system/include/textarea.html.jsp">
			<jsp:param name="textarea_classBox" value="x2" />
			<jsp:param name="textarea_mapping" value="ftps@${index}.note" />
			<jsp:param name="textarea_caption" value="${f:message(LOCALE, 'Note')}" />
		</jsp:include>
	</div>

	<%-- readOnly + menu --%>
	<div class="mdc-card__content adjacent gpro-display-flex-row">
		<%-- readOnly --%>
		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_mapping" value="ftps@${index}.readOnly" />
			<jsp:param name="switch_caption" value="${f:message(LOCALE, 'Sola_lettura')}" />
		</jsp:include>
		
		<span class="gpro-flex-grow"></span>

		<%-- menu --%>
		<div class="mdc-menu-surface--anchor menu-ops">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="gpro-mdc-menu-surface--anchor-trigger" />
				<jsp:param name="button_icon" value="more_vert" />
			</jsp:include>
			
			<div class="mdc-menu mdc-menu-surface menu-ops">
				<ul class="mdc-list" role="menu">
					<li class="mdc-list-item" role="menuitem">
						<span class="mdc-list-item__text row-container-remove"><html:message key="Elimina" /></span>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>