<%@ include file="/_core/system/directives.jsp"%>

<%@ page import="application.orm.persister.PhpFinder" %>

<%
	pageContext.setAttribute("PHPS", PhpFinder.getInstance().getAll());
%>

<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<input type="hidden" class="requirePageCSS" />

<input type="hidden" class="requirePageJS" />



<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- avvisi --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%-- sospeso --%>
<c:if test="${BEAN.pojo.sospeso}">
	<div class="mdc-card gpro-full-width alert">
		<div class="mdc-card__title">
			<h3 class="mdc-typography--headline4"><html:message key="Avviso_dominio_sospeso" /></h3>
		</div>
		<div class="mdc-card__content">
			<p class="note-highlight"><html:message key="Avviso_dominio_sospeso_dettaglio" /></p>
		</div>
	</div>
</c:if>

<%-- archiviato --%>
<c:if test="${BEAN.pojo.archiviato}">
	<div class="mdc-card gpro-full-width warning">
		<div class="mdc-card__title">
			<h3 class="mdc-typography--headline4"><html:message key="Avviso_dominio_archiviato" /></h3>
		</div>
		<div class="mdc-card__content">
			<p class="note-highlight"><html:message key="Avviso_dominio_archiviato_dettaglio" /></p>
		</div>
	</div>
</c:if>

<%-- alert --%>
<c:if test="${POJO.alert}">
	<div class="mdc-card gpro-full-width condition-background alert">
		<c:if test="${POJO.alertDns}">
			<div class="mdc-card__content">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_icon" value="public_off" />
				</jsp:include>
				<html:separator />
				<span class="gpro-vertical-align-middle"><html:message key="Alert_dns_message" /></span>
			</div>
		</c:if>
		<c:if test="${POJO.alertHttps}">
			<div class="mdc-card__content">
				<jsp:include page="/_core/system/include/icon.html.jsp">
					<jsp:param name="icon_icon" value="https" />
				</jsp:include>
				<html:separator />
				<span class="gpro-vertical-align-middle"><html:message key="Alert_https_message" /></span>
			</div>
		</c:if>
	</div>
</c:if>




<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>
<%-- scheda principale --%>
<%-- ------------------------------------------------------------------------------------------------------------------------------------------------------ --%>

<%-- domini + alias --%>
<div class="mdc-card domains">
	<html:input type="hidden" mapping="dominio.id" />
	
	<div class="mdc-card__title gpro-display-flex-row-center">
		<c:if test="${!BEAN.pojo.staging }">
			<jsp:include page="/_core/system/include/button.html.jsp">
				<jsp:param name="button_class" value="sidebar-button aggiungi-alias no-margin" />
				<jsp:param name="button_icon" value="playlist_add" />
				<jsp:param name="button_tooltip" value="${f:message(LOCALE, 'Aggiungi_alias')}" />
			</jsp:include>
		</c:if>
		
		<span class="gpro-flex-grow"><html:message key="${BEAN.pojo.staging ? 'Dominio' : 'Domini_e_alias'}" /></span>
	</div>

	<div class="mdc-card__content">
		<%-- dominio principale --%>
		<div>
			<jsp:include page="/_core/system/include/input.html.jsp">
				<jsp:param name="input_class" value="app-item-title-source" />
				<jsp:param name="input_classBox" value="x2 gpro-font-size-huge gpro-vertical-align-middle" />
				<jsp:param name="input_required" value="true" />
				<jsp:param name="input_readOnly" value="${BEAN.pojo.stored}" />
				<jsp:param name="input_dataTransform" value="lowercase" />
				<jsp:param name="input_mapping" value="dominio.nome" />
				<jsp:param name="input_placeHolder" value="${f:message(LOCALE, 'Dominio')}" />
			</jsp:include>

			<c:choose>
				<c:when test="${!BEAN.pojo.staging}">
					<jsp:include page="/_core/system/include/switch.html.jsp">
						<jsp:param name="switch_mapping" value="dominio.www" />
						<jsp:param name="switch_title" value="www" />
					</jsp:include>
					
					<img class="www" src="${APPLICATION.contextPath}/app/_custom/img/www.png" />
				</c:when>
				<c:otherwise>
					<html:input type="hidden" mapping="dominio.www" value="0" />
				</c:otherwise>
			</c:choose>
		</div>
	</div>

	<%-- alias --%>
	<c:choose>
		<c:when test="${BEAN.pojo.staging}">
			<div class="mdc-card__content alias-box gpro-js-alias-box gpro-font-size-huge gpro-text-align-center">
				<br />
				<span>staging → ${BEAN.pojo.stage.dominio.nome}</span>
				<br /><br />
			</div>
		</c:when>
		<c:otherwise>
			<div class="mdc-card__content alias-box gpro-js-alias-box ${' '} ${empty BEAN.alias ? 'with-empty-message' : ''}">
				<jsp:include page="/app/_common/emptyMessage.html.jsp">
					<jsp:param name="emptyMessage_hidden" value="${not empty BEAN.alias}" />
					<jsp:param name="emptyMessage_text" value="nessun_alias_inserito" />
				</jsp:include>
		
				<c:forEach items="${BEAN.alias}" varStatus="status">
					<jsp:include page="alias.html.jsp">
						<jsp:param name="index" value="${f:applicationEncode(status.index)}" />
					</jsp:include>
				</c:forEach>
			</div>
		</c:otherwise>
	</c:choose>
</div>

<%-- descrizione + note + php + backup --%>
<div class="mdc-card">
	<div class="mdc-card__title">
		<html:message key="Note" />
	</div>

	<div class="mdc-card__content">
		<%-- descrizione --%>
		<div>
			<jsp:include page="/_core/system/include/textarea.html.jsp">
				<jsp:param name="textarea_classBox" value="x2" />
				<jsp:param name="textarea_mapping" value="pojo.descrizione" />
				<jsp:param name="textarea_caption"
					value="${f:message(LOCALE, 'Descrizione')}" />
			</jsp:include>
		</div>

		<%-- note --%>
		<div>
			<jsp:include page="/_core/system/include/textarea.html.jsp">
				<jsp:param name="textarea_classBox" value="x2" />
				<jsp:param name="textarea_mapping" value="pojo.note" />
				<jsp:param name="textarea_caption"
					value="${f:message(LOCALE, 'Note')}" />
			</jsp:include>
		</div>
		
		<br />
		
		<%-- flags + php --%>
		<div class="gpro-display-flex-row-top">
			<%-- flags --%>
			<div>
				<%-- backup --%>
				<jsp:include page="/_core/system/include/switch.html.jsp">
					<jsp:param name="switch_mapping" value="pojo.backup" />
					<jsp:param name="switch_icon" value="shield" />
					<jsp:param name="switch_caption" value="Backup" />
				</jsp:include>

				<c:if test="${BEAN.pojo.stored}">
					<br />
	
					<%-- https --%>
					<jsp:include page="/_core/system/include/switch.html.jsp">
						<jsp:param name="switch_mapping" value="pojo.https" />
						<jsp:param name="switch_icon" value="https" />
						<jsp:param name="switch_caption" value="HTTPS" />
					</jsp:include>

					<%-- httpsRedirect --%>
					<jsp:include page="/_core/system/include/switch.html.jsp">
						<jsp:param name="switch_mapping" value="pojo.httpsRedirect" />
						<jsp:param name="switch_caption" value="Redirect" />
						<jsp:param name="switch_classBox" value="https-redirect ${!BEAN.pojo.https ? ' ui-helper-hidden ' : ''}" />
					</jsp:include>

					<c:choose>
						<c:when test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('STATS')}">
							<br />
			
							<%-- stat --%>
							<jsp:include page="/_core/system/include/switch.html.jsp">
								<jsp:param name="switch_mapping" value="pojo.statistiche" />
								<jsp:param name="switch_icon" value="analytics" />
								<jsp:param name="switch_caption" value="${f:message(LOCALE, 'Statistiche')}" />
							</jsp:include>
						</c:when>
						<c:otherwise>
							<html:input type="hidden" mapping="pojo.statistiche" value="0" />
						</c:otherwise>
					</c:choose>
				</c:if>
				
				<%-- cdn --%>
				<c:choose>
					<c:when test="${ACCOUNT.administrator || ACCOUNT.hasAutorizzazione('CDN')}">
						<br />
						
						<jsp:include page="/_core/system/include/switch.html.jsp">
							<jsp:param name="switch_mapping" value="pojo.cdn" />
							<jsp:param name="switch_icon" value="public" />
							<jsp:param name="switch_caption" value="CDN" />
						</jsp:include>
						<jsp:include page="/_core/system/include/input.html.jsp">
							<jsp:param name="input_classBox" value="x2_3 cdn-path" />
							<jsp:param name="input_mapping" value="pojo.cdnPath" />
							<jsp:param name="input_placeHolder" value="cdn path" />
						</jsp:include>
					</c:when>
					<c:otherwise>
						<html:input type="hidden" mapping="pojo.cdn" value="0" />
						<html:input type="hidden" mapping="pojo.cdnPath" value="" />
					</c:otherwise>
				</c:choose>
			</div>

			<span class="gpro-flex-grow"></span>
			
			<div >
				<%-- php --%>
				<c:set scope="page" var="options">
						-1|default||
					<c:forEach items="${PHPS}" var="php">
						${php.id}|${php.versione}||
					</c:forEach>
				</c:set>
				<jsp:include page="/_core/system/include/select.html.jsp">
					<jsp:param name="select_classBox" value="xauto" />
					<jsp:param name="select_mapping" value="pojo.idPhp" />
					<jsp:param name="select_options" value="${options}" />
					<jsp:param name="select_sorted" value="false" />
					<jsp:param name="select_caption" value="PHP" />
				</jsp:include>
			</div>
		</div>
	</div>
</div>

<div class="mdc-card">
	<div class="mdc-card__title">
		<html:message key="Applicazione" />
	</div>

	<div class="mdc-card__content">
		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_mapping" value="pojo.wordpress" />
			<jsp:param name="switch_caption" value="Wordpress" />
		</jsp:include>

		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_mapping" value="pojo.vtiger" />
			<jsp:param name="switch_caption" value="VTiger" />
		</jsp:include>

		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_mapping" value="pojo.magento" />
			<jsp:param name="switch_caption" value="Magento" />
		</jsp:include>

		<jsp:include page="/_core/system/include/switch.html.jsp">
			<jsp:param name="switch_mapping" value="pojo.angular" />
			<jsp:param name="switch_caption" value="Angular" />
		</jsp:include>
	</div>
</div>
